/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenPositionFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class LimitTokenPositionFilterFactory
extends TokenFilterFactory {
    public static final String MAX_TOKEN_POSITION_KEY = "maxTokenPosition";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    final int maxTokenPosition;
    final boolean consumeAllTokens;

    public LimitTokenPositionFilterFactory(Map<String, String> args2) {
        super(args2);
        this.maxTokenPosition = this.requireInt(args2, MAX_TOKEN_POSITION_KEY);
        this.consumeAllTokens = this.getBoolean(args2, CONSUME_ALL_TOKENS_KEY, false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public TokenStream create(TokenStream input2) {
        return new LimitTokenPositionFilter(input2, this.maxTokenPosition, this.consumeAllTokens);
    }
}

