/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class LimitTokenOffsetFilterFactory
extends TokenFilterFactory {
    public static final String MAX_START_OFFSET = "maxStartOffset";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    private int maxStartOffset;
    private boolean consumeAllTokens;

    public LimitTokenOffsetFilterFactory(Map<String, String> args2) {
        super(args2);
        this.maxStartOffset = this.requireInt(args2, MAX_START_OFFSET);
        this.consumeAllTokens = this.getBoolean(args2, CONSUME_ALL_TOKENS_KEY, false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public TokenStream create(TokenStream input2) {
        return new LimitTokenOffsetFilter(input2, this.maxStartOffset, this.consumeAllTokens);
    }
}

