/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class LimitTokenCountFilterFactory
extends TokenFilterFactory {
    public static final String MAX_TOKEN_COUNT_KEY = "maxTokenCount";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    final int maxTokenCount;
    final boolean consumeAllTokens;

    public LimitTokenCountFilterFactory(Map<String, String> args2) {
        super(args2);
        this.maxTokenCount = this.requireInt(args2, MAX_TOKEN_COUNT_KEY);
        this.consumeAllTokens = this.getBoolean(args2, CONSUME_ALL_TOKENS_KEY, false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public TokenStream create(TokenStream input2) {
        return new LimitTokenCountFilter(input2, this.maxTokenCount, this.consumeAllTokens);
    }
}

