/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.PatternKeywordMarkerFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class KeywordMarkerFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    public static final String PATTERN = "pattern";
    private final String wordFiles;
    private final String stringPattern;
    private final boolean ignoreCase;
    private Pattern pattern;
    private CharArraySet protectedWords;

    public KeywordMarkerFilterFactory(Map<String, String> args2) {
        super(args2);
        this.wordFiles = this.get(args2, PROTECTED_TOKENS);
        this.stringPattern = this.get(args2, PATTERN);
        this.ignoreCase = this.getBoolean(args2, "ignoreCase", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.wordFiles != null) {
            this.protectedWords = this.getWordSet(loader, this.wordFiles, this.ignoreCase);
        }
        if (this.stringPattern != null) {
            this.pattern = this.ignoreCase ? Pattern.compile(this.stringPattern, 66) : Pattern.compile(this.stringPattern);
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TokenStream create(TokenStream input2) {
        if (this.pattern != null) {
            input2 = new PatternKeywordMarkerFilter(input2, this.pattern);
        }
        if (this.protectedWords != null) {
            input2 = new SetKeywordMarkerFilter(input2, this.protectedWords);
        }
        return input2;
    }
}

