/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.KeepWordFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class KeepWordFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private final boolean ignoreCase;
    private final String wordFiles;
    private CharArraySet words;

    public KeepWordFilterFactory(Map<String, String> args2) {
        super(args2);
        this.wordFiles = this.get(args2, "words");
        this.ignoreCase = this.getBoolean(args2, "ignoreCase", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.wordFiles != null) {
            this.words = this.getWordSet(loader, this.wordFiles, this.ignoreCase);
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getWords() {
        return this.words;
    }

    @Override
    public TokenStream create(TokenStream input2) {
        if (this.words == null) {
            return input2;
        }
        KeepWordFilter filter2 = new KeepWordFilter(input2, this.words);
        return filter2;
    }
}

