/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.util.ArrayUtil;

public final class DelimitedTermFrequencyTokenFilter
extends TokenFilter {
    public static final char DEFAULT_DELIMITER = '|';
    private final char delimiter;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final TermFrequencyAttribute tfAtt = this.addAttribute(TermFrequencyAttribute.class);

    public DelimitedTermFrequencyTokenFilter(TokenStream input2) {
        this(input2, '|');
    }

    public DelimitedTermFrequencyTokenFilter(TokenStream input2, char delimiter) {
        super(input2);
        this.delimiter = delimiter;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            for (int i = 0; i < length; ++i) {
                if (buffer[i] != this.delimiter) continue;
                this.termAtt.setLength(i);
                this.tfAtt.setTermFrequency(ArrayUtil.parseInt(buffer, ++i, length - i));
                return true;
            }
            return true;
        }
        return false;
    }
}

