/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.DateRecognizerFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class DateRecognizerFilterFactory
extends TokenFilterFactory {
    public static final String DATE_PATTERN = "datePattern";
    public static final String LOCALE = "locale";
    private final DateFormat dateFormat;
    private final Locale locale;

    public DateRecognizerFilterFactory(Map<String, String> args2) {
        super(args2);
        this.locale = this.getLocale(this.get(args2, LOCALE));
        this.dateFormat = this.getDataFormat(this.get(args2, DATE_PATTERN));
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public TokenStream create(TokenStream input2) {
        return new DateRecognizerFilter(input2, this.dateFormat);
    }

    private Locale getLocale(String localeStr) {
        if (localeStr == null) {
            return Locale.ENGLISH;
        }
        return new Locale.Builder().setLanguageTag(localeStr).build();
    }

    public DateFormat getDataFormat(String datePattern) {
        if (datePattern != null) {
            return new SimpleDateFormat(datePattern, this.locale);
        }
        return DateFormat.getDateInstance(2, this.locale);
    }
}

