/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ConcatenateGraphFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ConcatenateGraphFilterFactory
extends TokenFilterFactory {
    private boolean preserveSep;
    private boolean preservePositionIncrements;
    private int maxGraphExpansions;

    public ConcatenateGraphFilterFactory(Map<String, String> args2) {
        super(args2);
        this.preserveSep = this.getBoolean(args2, "preserveSep", true);
        this.preservePositionIncrements = this.getBoolean(args2, "preservePositionIncrements", true);
        this.maxGraphExpansions = this.getInt(args2, "maxGraphExpansions", 10000);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public TokenStream create(TokenStream input2) {
        return new ConcatenateGraphFilter(input2, this.preserveSep, this.preservePositionIncrements, this.maxGraphExpansions);
    }
}

