/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ASCIIFoldingFilterFactory
extends TokenFilterFactory
implements MultiTermAwareComponent {
    private static final String PRESERVE_ORIGINAL = "preserveOriginal";
    private final boolean preserveOriginal;

    public ASCIIFoldingFilterFactory(Map<String, String> args2) {
        super(args2);
        this.preserveOriginal = this.getBoolean(args2, PRESERVE_ORIGINAL, false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public ASCIIFoldingFilter create(TokenStream input2) {
        return new ASCIIFoldingFilter(input2, this.preserveOriginal);
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        if (this.preserveOriginal) {
            HashMap<String, String> args2 = new HashMap<String, String>(this.getOriginalArgs());
            args2.remove(PRESERVE_ORIGINAL);
            return new ASCIIFoldingFilterFactory(args2);
        }
        return this;
    }
}

