/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.minhash;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.minhash.MinHashFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class MinHashFilterFactory
extends TokenFilterFactory {
    private int hashCount = 1;
    private int bucketCount = 512;
    private int hashSetSize = 1;
    private boolean withRotation;

    public MinHashFilterFactory(Map<String, String> args2) {
        super(args2);
        this.hashCount = this.getInt(args2, "hashCount", 1);
        this.bucketCount = this.getInt(args2, "bucketCount", 512);
        this.hashSetSize = this.getInt(args2, "hashSetSize", 1);
        this.withRotation = this.getBoolean(args2, "withRotation", this.bucketCount > 1);
    }

    @Override
    public TokenStream create(TokenStream input2) {
        return new MinHashFilter(input2, this.hashCount, this.bucketCount, this.hashSetSize, this.withRotation);
    }
}

