/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.Stemmer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.CharsRef;

public final class HunspellStemFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);
    private final Stemmer stemmer;
    private List<CharsRef> buffer;
    private AttributeSource.State savedState;
    private final boolean dedup;
    private final boolean longestOnly;
    static final Comparator<CharsRef> lengthComparator = new Comparator<CharsRef>(){

        @Override
        public int compare(CharsRef o1, CharsRef o2) {
            int cmp = Integer.compare(o2.length, o1.length);
            if (cmp == 0) {
                return o2.compareTo(o1);
            }
            return cmp;
        }
    };

    public HunspellStemFilter(TokenStream input2, Dictionary dictionary) {
        this(input2, dictionary, true);
    }

    public HunspellStemFilter(TokenStream input2, Dictionary dictionary, boolean dedup) {
        this(input2, dictionary, dedup, false);
    }

    public HunspellStemFilter(TokenStream input2, Dictionary dictionary, boolean dedup, boolean longestOnly) {
        super(input2);
        this.dedup = dedup && !longestOnly;
        this.stemmer = new Stemmer(dictionary);
        this.longestOnly = longestOnly;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.buffer != null && !this.buffer.isEmpty()) {
            CharsRef nextStem = this.buffer.remove(0);
            this.restoreState(this.savedState);
            this.posIncAtt.setPositionIncrement(0);
            this.termAtt.setEmpty().append(nextStem);
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.keywordAtt.isKeyword()) {
            return true;
        }
        List<CharsRef> list2 = this.buffer = this.dedup ? this.stemmer.uniqueStems(this.termAtt.buffer(), this.termAtt.length()) : this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
        if (this.buffer.isEmpty()) {
            return true;
        }
        if (this.longestOnly && this.buffer.size() > 1) {
            Collections.sort(this.buffer, lengthComparator);
        }
        CharsRef stem = this.buffer.remove(0);
        this.termAtt.setEmpty().append(stem);
        if (this.longestOnly) {
            this.buffer.clear();
        } else if (!this.buffer.isEmpty()) {
            this.savedState = this.captureState();
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.buffer = null;
    }
}

