/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;

public class LowerCaseTokenizerFactory
extends TokenizerFactory
implements MultiTermAwareComponent {
    private final int maxTokenLen;

    public LowerCaseTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.maxTokenLen = this.getInt(args2, "maxTokenLen", 255);
        if (this.maxTokenLen > 0x100000 || this.maxTokenLen <= 0) {
            throw new IllegalArgumentException("maxTokenLen must be greater than 0 and less than 1048576 passed: " + this.maxTokenLen);
        }
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public LowerCaseTokenizer create(AttributeFactory factory) {
        return new LowerCaseTokenizer(factory, this.maxTokenLen);
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        HashMap<String, String> map2 = new HashMap<String, String>(this.getOriginalArgs());
        map2.remove("maxTokenLen");
        return new LowerCaseFilterFactory(map2);
    }
}

