/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.util.Map;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;

public class KeywordTokenizerFactory
extends TokenizerFactory {
    private final int maxTokenLen;

    public KeywordTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.maxTokenLen = this.getInt(args2, "maxTokenLen", 256);
        if (this.maxTokenLen > 0x100000 || this.maxTokenLen <= 0) {
            throw new IllegalArgumentException("maxTokenLen must be greater than 0 and less than 1048576 passed: " + this.maxTokenLen);
        }
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public KeywordTokenizer create(AttributeFactory factory) {
        return new KeywordTokenizer(factory, this.maxTokenLen);
    }
}

