/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.IOUtils;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet dictionary;
    private HyphenationTree hyphenator;
    private final String dictFile;
    private final String hypFile;
    private final String encoding;
    private final int minWordSize;
    private final int minSubwordSize;
    private final int maxSubwordSize;
    private final boolean onlyLongestMatch;

    public HyphenationCompoundWordTokenFilterFactory(Map<String, String> args2) {
        super(args2);
        this.dictFile = this.get(args2, "dictionary");
        this.encoding = this.get(args2, "encoding");
        this.hypFile = this.require(args2, "hyphenator");
        this.minWordSize = this.getInt(args2, "minWordSize", 5);
        this.minSubwordSize = this.getInt(args2, "minSubwordSize", 2);
        this.maxSubwordSize = this.getInt(args2, "maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean(args2, "onlyLongestMatch", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        InputStream stream = null;
        try {
            if (this.dictFile != null) {
                this.dictionary = this.getWordSet(loader, this.dictFile, false);
            }
            stream = loader.openResource(this.hypFile);
            InputSource is = new InputSource(stream);
            is.setEncoding(this.encoding);
            is.setSystemId(this.hypFile);
            this.hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree(is);
        }
        catch (Throwable throwable2) {
            IOUtils.closeWhileHandlingException(stream);
            throw throwable2;
        }
        IOUtils.closeWhileHandlingException(stream);
    }

    @Override
    public TokenFilter create(TokenStream input2) {
        return new HyphenationCompoundWordTokenFilter(input2, this.hyphenator, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

