/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.DictionaryCompoundWordTokenFilter;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class DictionaryCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet dictionary;
    private final String dictFile;
    private final int minWordSize;
    private final int minSubwordSize;
    private final int maxSubwordSize;
    private final boolean onlyLongestMatch;

    public DictionaryCompoundWordTokenFilterFactory(Map<String, String> args2) {
        super(args2);
        this.dictFile = this.require(args2, "dictionary");
        this.minWordSize = this.getInt(args2, "minWordSize", 5);
        this.minSubwordSize = this.getInt(args2, "minSubwordSize", 2);
        this.maxSubwordSize = this.getInt(args2, "maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean(args2, "onlyLongestMatch", true);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.dictionary = super.getWordSet(loader, this.dictFile, false);
    }

    @Override
    public TokenStream create(TokenStream input2) {
        if (this.dictionary == null) {
            return input2;
        }
        return new DictionaryCompoundWordTokenFilter(input2, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

