/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class CJKBigramFilterFactory
extends TokenFilterFactory {
    final int flags;
    final boolean outputUnigrams;

    public CJKBigramFilterFactory(Map<String, String> args2) {
        super(args2);
        int flags = 0;
        if (this.getBoolean(args2, "han", true)) {
            flags |= 1;
        }
        if (this.getBoolean(args2, "hiragana", true)) {
            flags |= 2;
        }
        if (this.getBoolean(args2, "katakana", true)) {
            flags |= 4;
        }
        if (this.getBoolean(args2, "hangul", true)) {
            flags |= 8;
        }
        this.flags = flags;
        this.outputUnigrams = this.getBoolean(args2, "outputUnigrams", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public TokenStream create(TokenStream input2) {
        return new CJKBigramFilter(input2, this.flags, this.outputUnigrams);
    }
}

