/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public final class CJKAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public CJKAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public CJKAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result2 = new CJKWidthFilter(source);
        result2 = new LowerCaseFilter(result2);
        result2 = new CJKBigramFilter(result2);
        return new Analyzer.TokenStreamComponents(source, new StopFilter(result2, this.stopwords));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result2 = new CJKWidthFilter(in);
        result2 = new LowerCaseFilter(result2);
        return result2;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = CJKAnalyzer.loadStopwordSet(false, CJKAnalyzer.class, CJKAnalyzer.DEFAULT_STOPWORD_FILE, "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

