/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeSource;

public abstract class TokenStream
extends AttributeSource
implements Closeable {
    public static final AttributeFactory DEFAULT_TOKEN_ATTRIBUTE_FACTORY = AttributeFactory.getStaticImplementation(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, PackedTokenAttributeImpl.class);

    protected TokenStream() {
        super(DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
        assert (this.assertFinal());
    }

    protected TokenStream(AttributeSource input2) {
        super(input2);
        assert (this.assertFinal());
    }

    protected TokenStream(AttributeFactory factory) {
        super(factory);
        assert (this.assertFinal());
    }

    private boolean assertFinal() {
        try {
            Class<?> clazz2 = this.getClass();
            if (!clazz2.desiredAssertionStatus()) {
                return true;
            }
            assert (clazz2.isAnonymousClass() || (clazz2.getModifiers() & 0x12) != 0 || Modifier.isFinal(clazz2.getMethod("incrementToken", new Class[0]).getModifiers())) : "TokenStream implementation classes or at least their incrementToken() implementation must be final";
            return true;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
    }

    public abstract boolean incrementToken() throws IOException;

    public void end() throws IOException {
        this.endAttributes();
    }

    public void reset() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

