/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util.deque;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class FastSizeDeque<E>
implements Deque<E> {
    private final Deque<E> deque;
    private final LongAdder adder = new LongAdder();

    public FastSizeDeque(Deque<E> deque) {
        this.deque = Objects.requireNonNull(deque);
    }

    public int sizex() {
        return this.adder.intValue();
    }

    public boolean isEmptyx() {
        return this.adder.intValue() == 0;
    }

    @Override
    public void addFirst(E e) {
        this.deque.addFirst(e);
        this.adder.increment();
    }

    @Override
    public void addLast(E e) {
        this.deque.addLast(e);
        this.adder.increment();
    }

    @Override
    public boolean offerFirst(E e) {
        boolean res = this.deque.offerFirst(e);
        if (res) {
            this.adder.increment();
        }
        return res;
    }

    @Override
    public boolean offerLast(E e) {
        boolean res = this.deque.offerLast(e);
        if (res) {
            this.adder.increment();
        }
        return res;
    }

    @Override
    public E removeFirst() {
        E res = this.deque.removeFirst();
        this.adder.decrement();
        return res;
    }

    @Override
    public E removeLast() {
        E res = this.deque.removeLast();
        this.adder.decrement();
        return res;
    }

    @Override
    public E pollFirst() {
        E res = this.deque.pollFirst();
        if (res != null) {
            this.adder.decrement();
        }
        return res;
    }

    @Override
    public E pollLast() {
        E res = this.deque.pollFirst();
        if (res != null) {
            this.adder.decrement();
        }
        return res;
    }

    @Override
    public E getFirst() {
        return this.deque.getFirst();
    }

    @Override
    public E getLast() {
        return this.deque.getLast();
    }

    @Override
    public E peekFirst() {
        return this.deque.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.deque.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        boolean res = this.deque.removeFirstOccurrence(o);
        if (res) {
            this.adder.decrement();
        }
        return res;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        boolean res = this.deque.removeLastOccurrence(o);
        if (res) {
            this.adder.decrement();
        }
        return res;
    }

    @Override
    public boolean add(E e) {
        boolean alwaysTrue = this.deque.add(e);
        this.adder.increment();
        return alwaysTrue;
    }

    @Override
    public boolean offer(E e) {
        boolean res = this.deque.offer(e);
        if (res) {
            this.adder.increment();
        }
        return res;
    }

    @Override
    public E remove() {
        E res = this.deque.remove();
        this.adder.decrement();
        return res;
    }

    @Override
    public E poll() {
        E res = this.deque.poll();
        if (res != null) {
            this.adder.decrement();
        }
        return res;
    }

    @Override
    public E element() {
        return this.deque.element();
    }

    @Override
    public E peek() {
        return this.deque.peek();
    }

    @Override
    public void push(E e) {
        this.deque.push(e);
        this.adder.increment();
    }

    @Override
    public E pop() {
        E res = this.deque.pop();
        this.adder.decrement();
        return res;
    }

    @Override
    public boolean remove(Object o) {
        boolean res = this.deque.remove(o);
        if (res) {
            this.adder.decrement();
        }
        return res;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> col) {
        return this.deque.containsAll(col);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> col) {
        int colSize = col.size();
        boolean res = this.deque.addAll(col);
        if (res) {
            this.adder.add(colSize);
        }
        return res;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super E> pred) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.pollFirst() != null) {
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.deque.contains(o);
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iter(this.deque.iterator());
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.deque.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] ts) {
        return this.deque.toArray(ts);
    }

    @Override
    @NotNull
    public Iterator<E> descendingIterator() {
        return new Iter(this.deque.descendingIterator());
    }

    private class Iter
    implements Iterator<E> {
        private final Iterator<E> iter;

        private Iter(Iterator<E> iter2) {
            this.iter = iter2;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
            FastSizeDeque.this.adder.decrement();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            this.iter.forEachRemaining(consumer);
        }
    }
}

