/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.adaptive;

import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.loadbalancing.adaptive.AdaptiveLoadProbe;

public class AdaptiveJobCountLoadProbe
implements AdaptiveLoadProbe {
    private boolean useAvg = true;

    public AdaptiveJobCountLoadProbe() {
    }

    public AdaptiveJobCountLoadProbe(boolean useAvg) {
        this.useAvg = useAvg;
    }

    public boolean isUseAverage() {
        return this.useAvg;
    }

    public void setUseAverage(boolean useAvg) {
        this.useAvg = useAvg;
    }

    @Override
    public double getLoad(ClusterNode node, int jobsSentSinceLastUpdate) {
        double load2;
        ClusterMetrics metrics = node.metrics();
        if (this.useAvg && (load2 = (double)(metrics.getAverageActiveJobs() + metrics.getAverageWaitingJobs())) > 0.0) {
            return load2;
        }
        load2 = metrics.getCurrentActiveJobs() + metrics.getCurrentWaitingJobs();
        return load2 < 0.0 ? 0.0 : load2;
    }

    public String toString() {
        return S.toString(AdaptiveJobCountLoadProbe.class, this);
    }
}

