/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.adaptive;

import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.loadbalancing.adaptive.AdaptiveLoadProbe;

public class AdaptiveCpuLoadProbe
implements AdaptiveLoadProbe {
    private boolean useAvg = true;
    private boolean useProcs = true;
    private double procCoefficient = 1.0;

    public AdaptiveCpuLoadProbe() {
    }

    public AdaptiveCpuLoadProbe(boolean useAvg, boolean useProcs) {
        this.useAvg = useAvg;
        this.useProcs = useProcs;
    }

    public AdaptiveCpuLoadProbe(boolean useAvg, boolean useProcs, double procCoefficient) {
        this.useAvg = useAvg;
        this.useProcs = useProcs;
        this.procCoefficient = procCoefficient;
    }

    public boolean isUseAverage() {
        return this.useAvg;
    }

    public void setUseAverage(boolean useAvg) {
        this.useAvg = useAvg;
    }

    public boolean isUseProcessors() {
        return this.useProcs;
    }

    public void setUseProcessors(boolean useProcs) {
        this.useProcs = useProcs;
    }

    public double getProcessorCoefficient() {
        return this.procCoefficient;
    }

    public void setProcessorCoefficient(double procCoefficient) {
        A.ensure(procCoefficient > 0.0, "procCoefficient > 0");
        this.procCoefficient = procCoefficient;
    }

    @Override
    public double getLoad(ClusterNode node, int jobsSentSinceLastUpdate) {
        int procs;
        ClusterMetrics metrics = node.metrics();
        double k = 1.0;
        if (this.useProcs && (procs = metrics.getTotalCpus()) > 1) {
            k = (double)procs * this.procCoefficient;
        }
        double load2 = (this.useAvg ? metrics.getAverageCpuLoad() : metrics.getCurrentCpuLoad()) / k;
        return load2 < 0.0 ? 0.0 : load2;
    }

    public String toString() {
        return S.toString(AdaptiveCpuLoadProbe.class, this);
    }
}

