/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.sharedfs;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoverySharedFsIpFinder
extends TcpDiscoveryIpFinderAdapter {
    public static final String DFLT_PATH = "disco/tcp";
    public static final String DELIM = "#";
    private static final String COLON_DELIM = ":";
    private static final String COLON_SUBST = "_";
    @LoggerResource
    private IgniteLogger log;
    private String path = "disco/tcp";
    @GridToStringExclude
    private File folder;
    @GridToStringExclude
    private final AtomicBoolean warnGuard = new AtomicBoolean();
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public TcpDiscoverySharedFsIpFinder() {
        this.setShared(true);
    }

    public String getPath() {
        return this.path;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySharedFsIpFinder setPath(String path2) {
        this.path = path2;
        return this;
    }

    private File initFolder() throws IgniteSpiException {
        if (this.initGuard.compareAndSet(false, true)) {
            if (this.path == null) {
                throw new IgniteSpiException("Shared file system path is null (it should be configured via setPath(..) configuration property).");
            }
            if (this.path.equals(DFLT_PATH) && this.warnGuard.compareAndSet(false, true)) {
                U.warn(this.log, "Default local computer-only share is used by IP finder.");
            }
            try {
                File tmp;
                if (new File(this.path).exists()) {
                    tmp = new File(this.path);
                } else {
                    try {
                        tmp = U.resolveWorkDirectory(this.ignite.configuration().getWorkDirectory(), this.path, false);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteSpiException("Failed to resolve directory [path=" + this.path + ", exception=" + e.getMessage() + ']');
                    }
                }
                if (!tmp.isDirectory()) {
                    throw new IgniteSpiException("Failed to initialize shared file system path (path must point to folder): " + this.path);
                }
                if (!tmp.canRead() || !tmp.canWrite()) {
                    throw new IgniteSpiException("Failed to initialize shared file system path (path must be readable and writable): " + this.path);
                }
                this.folder = tmp;
            }
            finally {
                this.initLatch.countDown();
            }
        }
        try {
            U.await(this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", e);
        }
        if (this.folder == null) {
            throw new IgniteSpiException("Failed to initialize shared file system folder (check logs for errors).");
        }
        return this.folder;
    }

    @Override
    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.initFolder();
        LinkedList<InetSocketAddress> addrs = new LinkedList<InetSocketAddress>();
        for (String fileName : this.folder.list()) {
            StringTokenizer st = new StringTokenizer(fileName, DELIM);
            if (st.countTokens() != 2) continue;
            String addrStr = st.nextToken();
            String portStr = st.nextToken();
            try {
                int port = Integer.parseInt(portStr);
                addrs.add(new InetSocketAddress(this.denormalizeAddress(addrStr), port));
            }
            catch (IllegalArgumentException e) {
                U.error(this.log, "Failed to parse file entry: " + fileName, e);
            }
        }
        return Collections.unmodifiableCollection(addrs);
    }

    @Override
    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.initFolder();
        try {
            for (String name : this.distinctNames(addrs)) {
                File file = new File(this.folder, name);
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new IgniteSpiException("Failed to create file.", e);
        }
    }

    @Override
    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.initFolder();
        try {
            for (String name : this.distinctNames(addrs)) {
                File file = new File(this.folder, name);
                if (file.delete()) continue;
                throw new IgniteSpiException("Failed to delete file " + file.getName());
            }
        }
        catch (SecurityException e) {
            throw new IgniteSpiException("Failed to delete file.", e);
        }
    }

    private Iterable<String> distinctNames(Iterable<InetSocketAddress> addresses) {
        HashSet<String> result2 = new HashSet<String>();
        for (InetSocketAddress address : addresses) {
            result2.add(this.name(address));
        }
        return result2;
    }

    private String name(InetSocketAddress addr) {
        assert (addr != null);
        SB sb = new SB();
        sb.a(addr.isUnresolved() ? addr.getHostName() : this.normalizeAddress(addr.getAddress().getHostAddress())).a(DELIM).a(addr.getPort());
        return sb.toString();
    }

    private String normalizeAddress(String hostAddress) {
        return hostAddress.replaceAll(COLON_DELIM, COLON_SUBST);
    }

    private String denormalizeAddress(String hostAddress) {
        return hostAddress.replaceAll(COLON_SUBST, COLON_DELIM);
    }

    @Override
    public TcpDiscoverySharedFsIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoverySharedFsIpFinder.class, this);
    }
}

