/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.jdbc;

import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;
import org.apache.ignite.spi.discovery.tcp.ipfinder.jdbc.BasicJdbcIpFinderDialect;
import org.apache.ignite.spi.discovery.tcp.ipfinder.jdbc.JdbcIpFinderDialect;

public class TcpDiscoveryJdbcIpFinder
extends TcpDiscoveryIpFinderAdapter {
    @LoggerResource
    private IgniteLogger log;
    private DataSource dataSrc;
    private boolean initSchema = true;
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final String addrTableName;
    private final String getAddrsQry;
    private final String regAddrQry;
    private final String unregAddrQry;
    private final String createAddrsTableQry;
    private final String chkQry;

    public TcpDiscoveryJdbcIpFinder() {
        this(new BasicJdbcIpFinderDialect());
    }

    public TcpDiscoveryJdbcIpFinder(JdbcIpFinderDialect jdbcDialect) {
        this.setShared(true);
        this.addrTableName = jdbcDialect.tableName();
        this.getAddrsQry = "select hostname, port from " + this.addrTableName;
        this.regAddrQry = "insert into " + this.addrTableName + " values (?, ?)";
        this.unregAddrQry = "delete from " + this.addrTableName + " where hostname = ? and port = ?";
        this.createAddrsTableQry = "create table " + this.addrTableName + " (hostname VARCHAR(1024), port INT)";
        this.chkQry = "select count(*) from " + this.addrTableName;
    }

    @Override
    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        LinkedList<InetSocketAddress> linkedList;
        this.init();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSrc.getConnection();
            conn.setTransactionIsolation(2);
            stmt = conn.prepareStatement(this.getAddrsQry);
            rs = stmt.executeQuery();
            LinkedList<InetSocketAddress> addrs = new LinkedList<InetSocketAddress>();
            while (rs.next()) {
                addrs.add(new InetSocketAddress(rs.getString(1), rs.getInt(2)));
            }
            linkedList = addrs;
        }
        catch (SQLException e) {
            try {
                throw new IgniteSpiException("Failed to get registered addresses version.", e);
            }
            catch (Throwable throwable2) {
                U.closeQuiet(rs);
                U.closeQuiet(stmt);
                U.closeQuiet(conn);
                throw throwable2;
            }
        }
        U.closeQuiet(rs);
        U.closeQuiet(stmt);
        U.closeQuiet(conn);
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        PreparedStatement stmtReg;
        PreparedStatement stmtUnreg;
        Connection conn;
        block7: {
            assert (!F.isEmpty(addrs));
            this.init();
            conn = null;
            stmtUnreg = null;
            stmtReg = null;
            boolean committed = false;
            try {
                conn = this.dataSrc.getConnection();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(2);
                stmtUnreg = conn.prepareStatement(this.unregAddrQry);
                stmtReg = conn.prepareStatement(this.regAddrQry);
                for (InetSocketAddress addr : addrs) {
                    stmtUnreg.setString(1, addr.getAddress().getHostAddress());
                    stmtUnreg.setInt(2, addr.getPort());
                    stmtUnreg.addBatch();
                    stmtReg.setString(1, addr.getAddress().getHostAddress());
                    stmtReg.setInt(2, addr.getPort());
                    stmtReg.addBatch();
                }
                stmtUnreg.executeBatch();
                stmtUnreg.close();
                stmtReg.executeBatch();
                stmtReg.close();
                conn.commit();
                committed = true;
                if (committed) break block7;
            }
            catch (SQLException e) {
                try {
                    U.rollbackConnectionQuiet(conn);
                    throw new IgniteSpiException("Failed to register addresses: " + addrs, e);
                }
                catch (Throwable throwable2) {
                    if (!committed) {
                        U.rollbackConnectionQuiet(conn);
                    }
                    U.closeQuiet(stmtUnreg);
                    U.closeQuiet(stmtReg);
                    U.closeQuiet(conn);
                    throw throwable2;
                }
            }
            U.rollbackConnectionQuiet(conn);
        }
        U.closeQuiet(stmtUnreg);
        U.closeQuiet(stmtReg);
        U.closeQuiet(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        PreparedStatement stmt;
        Connection conn;
        block7: {
            assert (!F.isEmpty(addrs));
            this.init();
            conn = null;
            stmt = null;
            boolean committed = false;
            try {
                conn = this.dataSrc.getConnection();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(2);
                stmt = conn.prepareStatement(this.unregAddrQry);
                for (InetSocketAddress addr : addrs) {
                    stmt.setString(1, addr.getAddress().getHostAddress());
                    stmt.setInt(2, addr.getPort());
                    stmt.addBatch();
                }
                stmt.executeBatch();
                conn.commit();
                committed = true;
                if (committed) break block7;
            }
            catch (SQLException e) {
                try {
                    U.rollbackConnectionQuiet(conn);
                    throw new IgniteSpiException("Failed to unregister addresses: " + addrs, e);
                }
                catch (Throwable throwable2) {
                    if (!committed) {
                        U.rollbackConnectionQuiet(conn);
                    }
                    U.closeQuiet(stmt);
                    U.closeQuiet(conn);
                    throw throwable2;
                }
            }
            U.rollbackConnectionQuiet(conn);
        }
        U.closeQuiet(stmt);
        U.closeQuiet(conn);
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryJdbcIpFinder setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryJdbcIpFinder setInitSchema(boolean initSchema) {
        this.initSchema = initSchema;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws IgniteSpiException {
        if (this.initGuard.compareAndSet(false, true)) {
            if (this.dataSrc == null) {
                throw new IgniteSpiException("Data source is null (you must configure it via setDataSource(..) configuration property)");
            }
            if (!this.initSchema) {
                this.initLatch.countDown();
                this.checkSchema();
                return;
            }
            Connection conn = null;
            boolean committed = false;
            try {
                block48: {
                    conn = this.dataSrc.getConnection();
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(2);
                    DatabaseMetaData dbm = conn.getMetaData();
                    try (ResultSet tables = dbm.getTables(null, null, this.addrTableName, null);){
                        if (tables.next()) break block48;
                        try (Statement stmt = conn.createStatement();){
                            stmt.executeUpdate(this.createAddrsTableQry);
                            conn.commit();
                        }
                        catch (SQLException e) {
                            try (ResultSet tablesAgain = dbm.getTables(null, null, this.addrTableName, null);){
                                if (!tablesAgain.next()) {
                                    throw e;
                                }
                            }
                        }
                    }
                }
                committed = true;
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("DB schema has been initialized.");
                return;
            }
            catch (SQLException e) {
                U.rollbackConnectionQuiet(conn);
                throw new IgniteSpiException("Failed to initialize DB schema.", e);
            }
            finally {
                if (!committed) {
                    U.rollbackConnectionQuiet(conn);
                }
                U.closeQuiet(conn);
                this.initLatch.countDown();
            }
        }
        this.checkSchema();
    }

    private void checkSchema() throws IgniteSpiException {
        try {
            U.await(this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", e);
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.dataSrc.getConnection();
            conn.setTransactionIsolation(2);
            stmt = conn.createStatement();
            stmt.execute(this.chkQry);
        }
        catch (SQLException e) {
            try {
                throw new IgniteSpiException("IP finder has not been properly initialized.", e);
            }
            catch (Throwable throwable2) {
                U.closeQuiet(stmt);
                U.closeQuiet(conn);
                throw throwable2;
            }
        }
        U.closeQuiet(stmt);
        U.closeQuiet(conn);
    }

    @Override
    public TcpDiscoveryJdbcIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryJdbcIpFinder.class, this);
    }
}

