/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAuthenticationException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.AddressResolver;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpiInternalListener;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutException;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutHelper;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;
import org.apache.ignite.spi.IgniteSpiVersionCheckException;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiDataExchange;
import org.apache.ignite.spi.discovery.DiscoverySpiHistorySupport;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.DiscoverySpiMutableCustomMessageSupport;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.DiscoverySpiOrderSupport;
import org.apache.ignite.spi.discovery.tcp.ClientImpl;
import org.apache.ignite.spi.discovery.tcp.ServerImpl;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoveryImpl;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpiMBean;
import org.apache.ignite.spi.discovery.tcp.internal.DiscoveryDataPacket;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryStatistics;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAuthFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCheckFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryDuplicateIdMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryEnsureDelivery;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryJoinRequestMessage;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
@DiscoverySpiOrderSupport(value=true)
@DiscoverySpiHistorySupport(value=true)
@DiscoverySpiMutableCustomMessageSupport(value=true)
public class TcpDiscoverySpi
extends IgniteSpiAdapter
implements IgniteDiscoverySpi {
    public static final String ATTR_EXT_ADDRS = "disc.tcp.ext-addrs";
    public static final int DFLT_PORT_RANGE = 100;
    public static final int DFLT_PORT = 47500;
    public static final long DFLT_JOIN_TIMEOUT = 0L;
    public static final long DFLT_NETWORK_TIMEOUT = 5000L;
    public static final int DFLT_THREAD_PRI = 10;
    public static final int DFLT_TOP_HISTORY_SIZE = 1000;
    public static final long DFLT_SOCK_TIMEOUT = 5000L;
    public static final long DFLT_ACK_TIMEOUT = 5000L;
    public static final long DFLT_SOCK_TIMEOUT_CLIENT = 5000L;
    public static final long DFLT_ACK_TIMEOUT_CLIENT = 5000L;
    public static final int DFLT_RECONNECT_CNT = 10;
    public static final long DFLT_RECONNECT_DELAY = 2000L;
    public static final long DFLT_IP_FINDER_CLEAN_FREQ = 60000L;
    public static final long DFLT_STATS_PRINT_FREQ = 0L;
    public static final long DFLT_MAX_ACK_TIMEOUT = 600000L;
    public static final long DFLT_CONNECTION_RECOVERY_TIMEOUT = IgniteConfiguration.DFLT_FAILURE_DETECTION_TIMEOUT;
    private static Pattern sslMsgPattern = Pattern.compile("invalid stream header: 150\\d0\\d00");
    protected String locAddr;
    private AddressResolver addrRslvr;
    protected TcpDiscoveryIpFinder ipFinder;
    private long sockTimeout;
    private long ackTimeout;
    protected long netTimeout = 5000L;
    protected long joinTimeout = 0L;
    protected int threadPri = 10;
    protected long metricsUpdateFreq;
    protected int topHistSize = 1000;
    protected long connRecoveryTimeout = DFLT_CONNECTION_RECOVERY_TIMEOUT;
    protected volatile DiscoverySpiListener lsnr;
    protected DiscoverySpiDataExchange exchange;
    protected DiscoveryMetricsProvider metricsProvider;
    protected Map<String, Object> locNodeAttrs;
    protected IgniteProductVersion locNodeVer;
    protected TcpDiscoveryNode locNode;
    protected UUID cfgNodeId;
    protected InetAddress locHost;
    protected Collection<InetSocketAddress> locNodeAddrs;
    protected volatile long gridStartTime;
    private Marshaller marsh;
    protected final TcpDiscoveryStatistics stats = new TcpDiscoveryStatistics();
    protected int locPort = 47500;
    protected int locPortRange = 100;
    private int reconCnt = 10;
    private long reconDelay = 2000L;
    protected long statsPrintFreq = 0L;
    private long maxAckTimeout = 600000L;
    protected long ipFinderCleanFreq = 60000L;
    protected DiscoverySpiNodeAuthenticator nodeAuth;
    protected SSLServerSocketFactory sslSrvSockFactory;
    protected SSLSocketFactory sslSockFactory;
    @GridToStringExclude
    private final CountDownLatch ctxInitLatch = new CountDownLatch(1);
    protected final CopyOnWriteArrayList<IgniteInClosure<TcpDiscoveryAbstractMessage>> sndMsgLsnrs = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<IgniteInClosure<Socket>> incomeConnLsnrs = new CopyOnWriteArrayList();
    @LoggerResource
    protected IgniteLogger log;
    protected TcpDiscoveryImpl impl;
    private boolean forceSrvMode;
    private boolean clientReconnectDisabled;
    private Serializable consistentId;
    private IgniteBiTuple<Collection<String>, Collection<String>> addrs;
    protected IgniteSpiContext spiCtx;
    private IgniteDiscoverySpiInternalListener internalLsnr;

    public String getSpiState() {
        return this.impl.getSpiState();
    }

    public int getMessageWorkerQueueSize() {
        return this.impl.getMessageWorkerQueueSize();
    }

    public UUID getCoordinator() {
        return this.impl.getCoordinator();
    }

    @Override
    public Collection<ClusterNode> getRemoteNodes() {
        return this.impl.getRemoteNodes();
    }

    @Override
    @Nullable
    public ClusterNode getNode(UUID nodeId) {
        return this.impl.getNode(nodeId);
    }

    public ClusterNode getNode0(UUID id) {
        if (this.impl instanceof ServerImpl) {
            return ((ServerImpl)this.impl).getNode0(id);
        }
        return this.getNode(id);
    }

    @Override
    public boolean pingNode(UUID nodeId) {
        return this.impl.pingNode(nodeId);
    }

    @Override
    public void disconnect() throws IgniteSpiException {
        this.impl.disconnect();
    }

    @Override
    public void setAuthenticator(DiscoverySpiNodeAuthenticator auth) {
        this.nodeAuth = auth;
    }

    @Override
    public void sendCustomEvent(DiscoverySpiCustomMessage msg) throws IgniteException {
        IgniteDiscoverySpiInternalListener internalLsnr = this.internalLsnr;
        if (internalLsnr != null && !internalLsnr.beforeSendCustomEvent(this, this.log, msg)) {
            return;
        }
        this.impl.sendCustomEvent(msg);
    }

    @Override
    public void failNode(UUID nodeId, @Nullable String warning2) {
        this.impl.failNode(nodeId, warning2);
    }

    public void dumpDebugInfo() {
        this.impl.dumpDebugInfo(this.log);
    }

    @Override
    public boolean isClientMode() {
        if (this.impl == null) {
            throw new IllegalStateException("TcpDiscoverySpi has not started.");
        }
        return this.impl instanceof ClientImpl;
    }

    @Deprecated
    public boolean isForceServerMode() {
        return this.forceSrvMode;
    }

    @IgniteSpiConfiguration(optional=true)
    @Deprecated
    public TcpDiscoverySpi setForceServerMode(boolean forceSrvMode) {
        this.forceSrvMode = forceSrvMode;
        return this;
    }

    public boolean isClientReconnectDisabled() {
        return this.clientReconnectDisabled;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setClientReconnectDisabled(boolean clientReconnectDisabled) {
        this.clientReconnectDisabled = clientReconnectDisabled;
    }

    @Override
    @IgniteInstanceResource
    protected void injectResources(Ignite ignite) {
        super.injectResources(ignite);
        if (ignite != null) {
            this.setLocalAddress(ignite.configuration().getLocalHost());
            this.setAddressResolver(ignite.configuration().getAddressResolver());
            this.marsh = ignite instanceof IgniteKernal ? ((IgniteKernal)ignite).context().marshallerContext().jdkMarshaller() : new JdkMarshaller();
        }
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setLocalAddress(String locAddr) {
        if (this.locAddr == null) {
            this.locAddr = locAddr;
        }
        return this;
    }

    public String getLocalAddress() {
        return this.locAddr;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setAddressResolver(AddressResolver addrRslvr) {
        if (this.addrRslvr == null) {
            this.addrRslvr = addrRslvr;
        }
    }

    public AddressResolver getAddressResolver() {
        return this.addrRslvr;
    }

    public int getReconnectCount() {
        return this.reconCnt;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setReconnectCount(int reconCnt) {
        this.reconCnt = reconCnt;
        this.failureDetectionTimeoutEnabled(false);
        return this;
    }

    public long getReconnectDelay() {
        return this.reconDelay;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setReconnectDelay(int reconDelay) {
        this.reconDelay = reconDelay;
        return this;
    }

    public long getMaxAckTimeout() {
        return this.maxAckTimeout;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setMaxAckTimeout(long maxAckTimeout) {
        this.maxAckTimeout = maxAckTimeout;
        this.failureDetectionTimeoutEnabled(false);
        return this;
    }

    public int getLocalPort() {
        TcpDiscoveryNode locNode0 = this.locNode;
        return locNode0 != null ? locNode0.discoveryPort() : 0;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setLocalPort(int locPort) {
        this.locPort = locPort;
        return this;
    }

    public int getLocalPortRange() {
        return this.locPortRange;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setLocalPortRange(int locPortRange) {
        this.locPortRange = locPortRange;
        return this;
    }

    public long getStatisticsPrintFrequency() {
        return this.statsPrintFreq;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setStatisticsPrintFrequency(long statsPrintFreq) {
        this.statsPrintFreq = statsPrintFreq;
        return this;
    }

    public long getIpFinderCleanFrequency() {
        return this.ipFinderCleanFreq;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setIpFinderCleanFrequency(long ipFinderCleanFreq) {
        this.ipFinderCleanFreq = ipFinderCleanFreq;
        return this;
    }

    public TcpDiscoveryIpFinder getIpFinder() {
        return this.ipFinder;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setIpFinder(TcpDiscoveryIpFinder ipFinder) {
        this.ipFinder = ipFinder;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setSocketTimeout(long sockTimeout) {
        this.sockTimeout = sockTimeout;
        this.failureDetectionTimeoutEnabled(false);
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
        this.failureDetectionTimeoutEnabled(false);
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setNetworkTimeout(long netTimeout) {
        this.netTimeout = netTimeout;
        return this;
    }

    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setJoinTimeout(long joinTimeout) {
        this.joinTimeout = joinTimeout;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setThreadPriority(int threadPri) {
        this.threadPri = threadPri;
        return this;
    }

    public long getTopHistorySize() {
        return this.topHistSize;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoverySpi setTopHistorySize(int topHistSize) {
        if (topHistSize < 1000) {
            U.warn(this.log, "Topology history size should be greater than or equal to default size. Specified size will not be set [curSize=" + this.topHistSize + ", specifiedSize=" + topHistSize + ", defaultSize=" + 1000 + ']');
            return this;
        }
        this.topHistSize = topHistSize;
        return this;
    }

    public long getConnectionRecoveryTimeout() {
        return this.connRecoveryTimeout;
    }

    long getEffectiveConnectionRecoveryTimeout() {
        if (this.failureDetectionTimeoutEnabled() && this.failureDetectionTimeout() < this.connRecoveryTimeout) {
            return this.failureDetectionTimeout();
        }
        return this.connRecoveryTimeout;
    }

    public void setConnectionRecoveryTimeout(long connRecoveryTimeout) {
        this.connRecoveryTimeout = connRecoveryTimeout;
    }

    @Override
    public void setNodeAttributes(Map<String, Object> attrs, IgniteProductVersion ver) {
        assert (this.locNodeAttrs == null);
        assert (this.locNodeVer == null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Node attributes to set: " + attrs);
            this.log.debug("Node version to set: " + ver);
        }
        this.locNodeAttrs = attrs;
        this.locNodeVer = ver;
    }

    public UUID getLocalNodeId() {
        return this.ignite.cluster().localNode().id();
    }

    @Override
    @Nullable
    public Serializable consistentId() throws IgniteSpiException {
        if (this.consistentId == null) {
            this.initializeImpl();
            this.initAddresses();
            IgniteConfiguration cfg = this.ignite.configuration();
            Serializable cfgId = cfg.getConsistentId();
            if (cfgId == null) {
                if (cfg.isClientMode() == Boolean.TRUE) {
                    this.consistentId = cfg.getNodeId();
                } else {
                    ArrayList<String> sortedAddrs = new ArrayList<String>(this.addrs.get1());
                    Collections.sort(sortedAddrs);
                    this.consistentId = IgniteSystemProperties.getBoolean("IGNITE_CONSISTENT_ID_BY_HOST_WITHOUT_PORT") ? U.consistentId(sortedAddrs) : U.consistentId(sortedAddrs, this.impl.boundPort());
                }
            } else {
                this.consistentId = cfgId;
            }
        }
        return this.consistentId;
    }

    private void initAddresses() {
        if (this.addrs == null) {
            try {
                this.addrs = U.resolveLocalAddresses(this.locHost);
            }
            catch (IOException | IgniteCheckedException e) {
                throw new IgniteSpiException("Failed to resolve local host to set of external addresses: " + this.locHost, e);
            }
        }
    }

    protected void initLocalNode(int srvPort, boolean addExtAddrAttr) {
        this.initAddresses();
        this.locNode = new TcpDiscoveryNode(this.ignite.configuration().getNodeId(), this.addrs.get1(), this.addrs.get2(), srvPort, this.metricsProvider, this.locNodeVer, this.consistentId());
        if (addExtAddrAttr) {
            Collection<InetSocketAddress> extAddrs = this.addrRslvr == null ? null : U.resolveAddresses(this.addrRslvr, F.flat(Arrays.asList(this.addrs.get1(), this.addrs.get2())), this.locNode.discoveryPort());
            this.locNodeAddrs = new LinkedHashSet<InetSocketAddress>();
            this.locNodeAddrs.addAll(this.locNode.socketAddresses());
            if (extAddrs != null) {
                this.locNodeAttrs.put(this.createSpiAttributeName(ATTR_EXT_ADDRS), extAddrs);
                this.locNodeAddrs.addAll(extAddrs);
            }
        }
        this.locNode.setAttributes(this.locNodeAttrs);
        this.locNode.local(true);
        DiscoverySpiListener lsnr = this.lsnr;
        if (lsnr != null) {
            lsnr.onLocalNodeInitialized(this.locNode);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Local node initialized: " + this.locNode);
        }
    }

    LinkedHashSet<InetSocketAddress> getNodeAddresses(TcpDiscoveryNode node) {
        LinkedHashSet<InetSocketAddress> res = new LinkedHashSet<InetSocketAddress>(node.socketAddresses());
        Collection extAddrs = (Collection)node.attribute(this.createSpiAttributeName(ATTR_EXT_ADDRS));
        if (extAddrs != null) {
            res.addAll(extAddrs);
        }
        return res;
    }

    LinkedHashSet<InetSocketAddress> getNodeAddresses(TcpDiscoveryNode node, boolean sameHost) {
        List addrs = U.arrayList(node.socketAddresses());
        Collections.sort(addrs, U.inetAddressesComparator(sameHost));
        LinkedHashSet<InetSocketAddress> res = new LinkedHashSet<InetSocketAddress>();
        InetSocketAddress lastAddr = node.lastSuccessfulAddress();
        if (lastAddr != null) {
            res.add(lastAddr);
        }
        res.addAll(addrs);
        Collection extAddrs = (Collection)node.attribute(this.createSpiAttributeName(ATTR_EXT_ADDRS));
        if (extAddrs != null) {
            res.addAll(extAddrs);
        }
        return res;
    }

    @Override
    public Collection<Object> injectables() {
        return F.asList(this.ipFinder);
    }

    public long getSocketTimeout() {
        return this.sockTimeout;
    }

    public long getEffectiveSocketTimeout(boolean srvrOperation) {
        if (this.failureDetectionTimeoutEnabled()) {
            return srvrOperation ? this.failureDetectionTimeout() : this.clientFailureDetectionTimeout();
        }
        return this.sockTimeout;
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public long getNetworkTimeout() {
        return this.netTimeout;
    }

    public int getThreadPriority() {
        return this.threadPri;
    }

    public String getIpFinderFormatted() {
        return this.ipFinder.toString();
    }

    public long getNodesJoined() {
        return this.stats.joinedNodesCount();
    }

    public long getNodesLeft() {
        return this.stats.leftNodesCount();
    }

    public long getNodesFailed() {
        return this.stats.failedNodesCount();
    }

    public long getPendingMessagesRegistered() {
        return this.stats.pendingMessagesRegistered();
    }

    public long getPendingMessagesDiscarded() {
        return this.stats.pendingMessagesDiscarded();
    }

    public long getAvgMessageProcessingTime() {
        return this.stats.avgMessageProcessingTime();
    }

    public long getMaxMessageProcessingTime() {
        return this.stats.maxMessageProcessingTime();
    }

    public int getTotalReceivedMessages() {
        return this.stats.totalReceivedMessages();
    }

    public Map<String, Integer> getReceivedMessages() {
        return this.stats.receivedMessages();
    }

    public int getTotalProcessedMessages() {
        return this.stats.totalProcessedMessages();
    }

    public Map<String, Integer> getProcessedMessages() {
        return this.stats.processedMessages();
    }

    public long getCoordinatorSinceTimestamp() {
        return this.stats.coordinatorSinceTimestamp();
    }

    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        super.onContextInitialized0(spiCtx);
        this.spiCtx = spiCtx;
        this.ctxInitLatch.countDown();
        this.ipFinder.onSpiContextInitialized(spiCtx);
        this.impl.onContextInitialized0(spiCtx);
    }

    @Override
    protected void onContextDestroyed0() {
        super.onContextDestroyed0();
        if (this.ctxInitLatch.getCount() > 0L) {
            this.ctxInitLatch.countDown();
        }
        if (this.ipFinder != null) {
            this.ipFinder.onSpiContextDestroyed();
        }
        this.getSpiContext().deregisterPorts();
    }

    @Override
    public IgniteSpiContext getSpiContext() {
        if (this.ctxInitLatch.getCount() > 0L) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Waiting for context initialization.");
            }
            try {
                U.await(this.ctxInitLatch);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Context has been initialized.");
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                U.warn(this.log, "Thread has been interrupted while waiting for SPI context initialization.", e);
            }
        }
        return super.getSpiContext();
    }

    @Override
    public ClusterNode getLocalNode() {
        return this.locNode;
    }

    @Override
    public void setListener(@Nullable DiscoverySpiListener lsnr) {
        this.lsnr = lsnr;
    }

    @Override
    public void setDataExchange(DiscoverySpiDataExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setMetricsProvider(DiscoveryMetricsProvider metricsProvider) {
        this.metricsProvider = metricsProvider;
    }

    @Override
    public long getGridStartTime() {
        assert (this.gridStartTime != 0L);
        return this.gridStartTime;
    }

    protected Socket openSocket(InetSocketAddress sockAddr, IgniteSpiOperationTimeoutHelper timeoutHelper) throws IOException, IgniteSpiOperationTimeoutException {
        return this.openSocket(this.createSocket(), sockAddr, timeoutHelper);
    }

    final BufferedOutputStream socketStream(Socket sock) throws IOException {
        int bufSize = sock.getSendBufferSize();
        return bufSize > 0 ? new BufferedOutputStream(sock.getOutputStream(), bufSize) : new BufferedOutputStream(sock.getOutputStream());
    }

    protected Socket openSocket(Socket sock, InetSocketAddress remAddr, IgniteSpiOperationTimeoutHelper timeoutHelper) throws IOException, IgniteSpiOperationTimeoutException {
        assert (remAddr != null);
        try {
            InetSocketAddress resolved = remAddr.isUnresolved() ? new InetSocketAddress(InetAddress.getByName(remAddr.getHostName()), remAddr.getPort()) : remAddr;
            InetAddress addr = resolved.getAddress();
            assert (addr != null);
            sock.connect(resolved, (int)timeoutHelper.nextTimeoutChunk(this.sockTimeout));
            this.writeToSocket(sock, null, U.IGNITE_HEADER, timeoutHelper.nextTimeoutChunk(this.sockTimeout));
            return sock;
        }
        catch (IOException | IgniteSpiOperationTimeoutException e) {
            if (sock != null) {
                U.closeQuiet(sock);
            }
            throw e;
        }
    }

    Socket createSocket() throws IOException {
        Socket sock = null;
        try {
            sock = this.isSslEnabled() ? this.sslSockFactory.createSocket() : new Socket();
            sock.bind(new InetSocketAddress(this.locHost, 0));
            sock.setTcpNoDelay(true);
            return sock;
        }
        catch (IOException e) {
            if (sock != null) {
                U.closeQuiet(sock);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToSocket(Socket sock, TcpDiscoveryAbstractMessage msg, byte[] data, long timeout) throws IOException {
        block9: {
            assert (sock != null);
            assert (data != null);
            SocketTimeoutObject obj = new SocketTimeoutObject(sock, U.currentTimeMillis() + timeout);
            this.addTimeoutObject(obj);
            IOException err2 = null;
            try {
                OutputStream out = sock.getOutputStream();
                out.write(data);
                out.flush();
            }
            catch (IOException e) {
                err2 = e;
            }
            finally {
                boolean cancelled = obj.cancel();
                if (cancelled) {
                    this.removeTimeoutObject(obj);
                }
                if (err2 != null) {
                    throw err2;
                }
                if (cancelled) break block9;
                throw new SocketTimeoutException("Write timed out (socket was concurrently closed).");
            }
        }
    }

    protected void writeToSocket(Socket sock, TcpDiscoveryAbstractMessage msg, long timeout) throws IOException, IgniteCheckedException {
        this.writeToSocket(sock, this.socketStream(sock), msg, timeout);
    }

    protected void startMessageProcess(TcpDiscoveryAbstractMessage msg) {
    }

    protected void writeToSocket(ClusterNode node, Socket sock, OutputStream out, TcpDiscoveryAbstractMessage msg, long timeout) throws IOException, IgniteCheckedException {
        this.writeToSocket(sock, out, msg, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToSocket(Socket sock, OutputStream out, TcpDiscoveryAbstractMessage msg, long timeout) throws IOException, IgniteCheckedException {
        block11: {
            if (this.internalLsnr != null && msg instanceof TcpDiscoveryJoinRequestMessage) {
                this.internalLsnr.beforeJoin(this.locNode, this.log);
            }
            assert (sock != null);
            assert (msg != null);
            assert (out != null);
            SocketTimeoutObject obj = new SocketTimeoutObject(sock, U.currentTimeMillis() + timeout);
            this.addTimeoutObject(obj);
            IgniteCheckedException err2 = null;
            try {
                U.marshal(this.marshaller(), msg, out);
            }
            catch (IgniteCheckedException e) {
                err2 = e;
            }
            finally {
                boolean cancelled = obj.cancel();
                if (cancelled) {
                    this.removeTimeoutObject(obj);
                }
                if (err2 != null) {
                    throw err2;
                }
                if (cancelled) break block11;
                throw new SocketTimeoutException("Write timed out (socket was concurrently closed).");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToSocket(TcpDiscoveryAbstractMessage msg, Socket sock, int res, long timeout) throws IOException {
        block8: {
            assert (sock != null);
            SocketTimeoutObject obj = new SocketTimeoutObject(sock, U.currentTimeMillis() + timeout);
            this.addTimeoutObject(obj);
            OutputStream out = sock.getOutputStream();
            IOException err2 = null;
            try {
                out.write(res);
                out.flush();
            }
            catch (IOException e) {
                err2 = e;
            }
            finally {
                boolean cancelled = obj.cancel();
                if (cancelled) {
                    this.removeTimeoutObject(obj);
                }
                if (err2 != null) {
                    throw err2;
                }
                if (cancelled) break block8;
                throw new SocketTimeoutException("Write timed out (socket was concurrently closed).");
            }
        }
    }

    protected <T> T readMessage(Socket sock, @Nullable InputStream in, long timeout) throws IOException, IgniteCheckedException {
        Object t;
        assert (sock != null);
        int oldTimeout = sock.getSoTimeout();
        try {
            Object res;
            sock.setSoTimeout((int)timeout);
            t = res = U.unmarshal(this.marshaller(), in == null ? sock.getInputStream() : in, U.resolveClassLoader(this.ignite.configuration()));
        }
        catch (IOException | IgniteCheckedException e) {
            String msg;
            StreamCorruptedException streamCorruptedCause;
            if (X.hasCause(e, SocketTimeoutException.class)) {
                LT.warn(this.log, "Timed out waiting for message to be read (most probably, the reason is long GC pauses on remote node) [curTimeout=" + timeout + ", rmtAddr=" + sock.getRemoteSocketAddress() + ", rmtPort=" + sock.getPort() + ']');
            }
            if ((streamCorruptedCause = X.cause(e, StreamCorruptedException.class)) != null && (msg = streamCorruptedCause.getMessage()) != null && sslMsgPattern.matcher(msg).matches()) {
                streamCorruptedCause.initCause(new SSLException("Detected SSL alert in StreamCorruptedException"));
            }
            throw e;
        }
        finally {
            try {
                sock.setSoTimeout(oldTimeout);
            }
            catch (SocketException socketException) {}
        }
        return t;
    }

    protected int readReceipt(Socket sock, long timeout) throws IOException {
        assert (sock != null);
        int oldTimeout = sock.getSoTimeout();
        try {
            sock.setSoTimeout((int)timeout);
            int res = sock.getInputStream().read();
            if (res == -1) {
                throw new EOFException();
            }
            int n = res;
            return n;
        }
        catch (SocketTimeoutException e) {
            LT.warn(this.log, "Timed out waiting for message delivery receipt (most probably, the reason is in long GC pauses on remote node; consider tuning GC and increasing 'ackTimeout' configuration property). Will retry to send message with increased timeout [currentTimeout=" + timeout + ", rmtAddr=" + sock.getRemoteSocketAddress() + ", rmtPort=" + sock.getPort() + ']');
            this.stats.onAckTimeout();
            throw e;
        }
        finally {
            try {
                sock.setSoTimeout(oldTimeout);
            }
            catch (SocketException socketException) {}
        }
    }

    protected Collection<InetSocketAddress> resolvedAddresses() throws IgniteSpiException {
        Collection<InetSocketAddress> addrs;
        ArrayList<InetSocketAddress> res = new ArrayList<InetSocketAddress>();
        while (true) {
            try {
                addrs = this.registeredAddresses();
                break;
            }
            catch (IgniteSpiException e) {
                LT.error(this.log, e, "Failed to get registered addresses from IP finder on start (retrying every " + this.getReconnectDelay() + "ms; change 'reconnectDelay' to configure the frequency of retries).");
                try {
                    U.sleep(this.getReconnectDelay());
                }
                catch (IgniteInterruptedCheckedException e2) {
                    throw new IgniteSpiException("Thread has been interrupted.", e2);
                }
            }
        }
        for (InetSocketAddress addr : addrs) {
            assert (addr != null);
            try {
                InetSocketAddress resolved;
                InetSocketAddress inetSocketAddress = resolved = addr.isUnresolved() ? new InetSocketAddress(InetAddress.getByName(addr.getHostName()), addr.getPort()) : addr;
                if (this.locNodeAddrs != null && this.locNodeAddrs.contains(resolved)) continue;
                res.add(resolved);
            }
            catch (UnknownHostException ignored) {
                LT.warn(this.log, "Failed to resolve address from IP finder (host is unknown): " + addr);
                res.add(addr);
            }
        }
        if (!res.isEmpty()) {
            Collections.shuffle(res);
        }
        return res;
    }

    protected Collection<InetSocketAddress> registeredAddresses() throws IgniteSpiException {
        ArrayList<InetSocketAddress> res = new ArrayList<InetSocketAddress>();
        for (InetSocketAddress addr : this.ipFinder.getRegisteredAddresses()) {
            if (addr.getPort() == 0) {
                int port = this.locNode.discoveryPort() != 0 ? this.locNode.discoveryPort() : 47500;
                addr = addr.isUnresolved() ? new InetSocketAddress(addr.getHostName(), port) : new InetSocketAddress(addr.getAddress(), port);
            }
            res.add(addr);
        }
        return res;
    }

    protected IgniteSpiException duplicateIdError(TcpDiscoveryDuplicateIdMessage msg) {
        assert (msg != null);
        return new IgniteSpiException("Local node has the same ID as existing node in topology (fix configuration and restart local node) [localNode=" + this.locNode + ", existingNode=" + msg.node() + ']');
    }

    protected IgniteSpiException authenticationFailedError(TcpDiscoveryAuthFailedMessage msg) {
        assert (msg != null);
        return new IgniteSpiException(new IgniteAuthenticationException("Authentication failed [nodeId=" + msg.creatorNodeId() + ", addr=" + msg.address().getHostAddress() + ']'));
    }

    protected IgniteSpiException checkFailedError(TcpDiscoveryCheckFailedMessage msg) {
        assert (msg != null);
        return TcpDiscoverySpi.versionCheckFailed(msg) ? new IgniteSpiVersionCheckException(msg.error()) : new IgniteSpiException(msg.error());
    }

    protected boolean ensured(TcpDiscoveryAbstractMessage msg) {
        return U.getAnnotation(msg.getClass(), TcpDiscoveryEnsureDelivery.class) != null;
    }

    @Deprecated
    private static boolean versionCheckFailed(TcpDiscoveryCheckFailedMessage msg) {
        return msg.error().contains("versions are not compatible");
    }

    DiscoveryDataPacket collectExchangeData(DiscoveryDataPacket dataPacket) {
        if (this.locNode.isDaemon()) {
            return dataPacket;
        }
        assert (dataPacket != null);
        assert (dataPacket.joiningNodeId() != null);
        DiscoveryDataBag dataBag = dataPacket.bagForDataCollection();
        this.exchange.collect(dataBag);
        if (dataPacket.joiningNodeId().equals(this.locNode.id())) {
            dataPacket.marshalJoiningNodeData(dataBag, this.marshaller(), this.log);
        } else {
            dataPacket.marshalGridNodeData(dataBag, this.locNode.id(), this.marshaller(), this.log);
        }
        return dataPacket;
    }

    protected void onExchange(DiscoveryDataPacket dataPacket, ClassLoader clsLdr) {
        if (this.locNode.isDaemon()) {
            return;
        }
        assert (dataPacket != null);
        assert (dataPacket.joiningNodeId() != null);
        DiscoveryDataBag dataBag = dataPacket.joiningNodeId().equals(this.locNode.id()) ? dataPacket.unmarshalGridData(this.marshaller(), clsLdr, this.locNode.clientRouterNodeId() != null, this.log) : dataPacket.unmarshalJoiningNodeData(this.marshaller(), clsLdr, this.locNode.clientRouterNodeId() != null, this.log);
        this.exchange.onExchange(dataBag);
    }

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.initializeImpl();
        this.registerMBean(igniteInstanceName, new TcpDiscoverySpiMBeanImpl(this), TcpDiscoverySpiMBean.class);
        this.impl.spiStart(igniteInstanceName);
    }

    private void initializeImpl() {
        TcpDiscoveryMulticastIpFinder mcastIpFinder;
        if (this.impl != null) {
            return;
        }
        this.initFailureDetectionTimeout();
        if (!this.forceSrvMode && Boolean.TRUE.equals(this.ignite.configuration().isClientMode())) {
            if (this.ackTimeout == 0L) {
                this.ackTimeout = 5000L;
            }
            if (this.sockTimeout == 0L) {
                this.sockTimeout = 5000L;
            }
            this.impl = new ClientImpl(this);
            this.ctxInitLatch.countDown();
        } else {
            if (this.ackTimeout == 0L) {
                this.ackTimeout = 5000L;
            }
            if (this.sockTimeout == 0L) {
                this.sockTimeout = 5000L;
            }
            this.impl = new ServerImpl(this);
        }
        this.metricsUpdateFreq = this.ignite.configuration().getMetricsUpdateFrequency();
        if (!this.failureDetectionTimeoutEnabled()) {
            this.assertParameter(this.sockTimeout > 0L, "sockTimeout > 0");
            this.assertParameter(this.ackTimeout > 0L, "ackTimeout > 0");
            this.assertParameter(this.maxAckTimeout > this.ackTimeout, "maxAckTimeout > ackTimeout");
            this.assertParameter(this.reconCnt > 0, "reconnectCnt > 0");
        }
        this.assertParameter(this.netTimeout > 0L, "networkTimeout > 0");
        this.assertParameter(this.ipFinder != null, "ipFinder != null");
        this.assertParameter(this.metricsUpdateFreq > 0L, "metricsUpdateFreq > 0 (inited from igniteConfiguration.metricsUpdateFrequency)");
        this.assertParameter(this.ipFinderCleanFreq > 0L, "ipFinderCleanFreq > 0");
        this.assertParameter(this.locPort > 1023, "localPort > 1023");
        this.assertParameter(this.locPortRange >= 0, "localPortRange >= 0");
        this.assertParameter(this.locPort + this.locPortRange <= 65535, "locPort + locPortRange <= 0xffff");
        this.assertParameter(this.threadPri > 0, "threadPri > 0");
        this.assertParameter(this.statsPrintFreq >= 0L, "statsPrintFreq >= 0");
        if (this.isSslEnabled()) {
            try {
                SSLContext sslCtx = this.ignite().configuration().getSslContextFactory().create();
                this.sslSockFactory = sslCtx.getSocketFactory();
                this.sslSrvSockFactory = sslCtx.getServerSocketFactory();
            }
            catch (IgniteException e) {
                throw new IgniteSpiException("Failed to create SSL context. SSL factory: " + this.ignite.configuration().getSslContextFactory(), e);
            }
        }
        try {
            this.locHost = U.resolveLocalHost(this.locAddr);
        }
        catch (IOException e) {
            throw new IgniteSpiException("Unknown local address: " + this.locAddr, e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("localHost", this.locHost.getHostAddress()));
            this.log.debug(this.configInfo("localPort", this.locPort));
            this.log.debug(this.configInfo("localPortRange", this.locPortRange));
            this.log.debug(this.configInfo("threadPri", this.threadPri));
            if (!this.failureDetectionTimeoutEnabled()) {
                this.log.debug("Failure detection timeout is ignored because at least one of the parameters from this list has been set explicitly: 'sockTimeout', 'ackTimeout', 'maxAckTimeout', 'reconnectCount'.");
                this.log.debug(this.configInfo("networkTimeout", this.netTimeout));
                this.log.debug(this.configInfo("sockTimeout", this.sockTimeout));
                this.log.debug(this.configInfo("ackTimeout", this.ackTimeout));
                this.log.debug(this.configInfo("maxAckTimeout", this.maxAckTimeout));
                this.log.debug(this.configInfo("reconnectCount", this.reconCnt));
            } else {
                this.log.debug(this.configInfo("failureDetectionTimeout", this.failureDetectionTimeout()));
            }
            this.log.debug(this.configInfo("ipFinder", this.ipFinder));
            this.log.debug(this.configInfo("ipFinderCleanFreq", this.ipFinderCleanFreq));
            this.log.debug(this.configInfo("metricsUpdateFreq", this.metricsUpdateFreq));
            this.log.debug(this.configInfo("statsPrintFreq", this.statsPrintFreq));
        }
        if (this.netTimeout < 3000L) {
            U.warn(this.log, "Network timeout is too low (at least 3000 ms recommended): " + this.netTimeout);
        }
        if (this.ipFinder instanceof TcpDiscoveryMulticastIpFinder && (mcastIpFinder = (TcpDiscoveryMulticastIpFinder)this.ipFinder).getLocalAddress() == null) {
            mcastIpFinder.setLocalAddress(this.locAddr);
        }
        this.cfgNodeId = this.ignite.configuration().getNodeId();
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        if (this.ctxInitLatch.getCount() > 0L) {
            this.ctxInitLatch.countDown();
        }
        if (this.ipFinder != null) {
            try {
                this.ipFinder.close();
            }
            catch (Exception e) {
                this.log.error("Failed to close ipFinder", e);
            }
        }
        this.unregisterMBean();
        if (this.impl != null) {
            this.impl.spiStop();
        }
    }

    void printStartInfo() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    void printStopInfo() {
        IgniteLogger log2 = this.log;
        if (log2 != null && log2.isDebugEnabled()) {
            log2.debug(this.stopInfo());
        }
    }

    boolean isNodeStopping0() {
        return this.isNodeStopping();
    }

    boolean ipFinderHasLocalAddress() throws IgniteSpiException {
        for (InetSocketAddress locAddr : this.locNodeAddrs) {
            for (InetSocketAddress addr : this.registeredAddresses()) {
                try {
                    int port = addr.getPort();
                    InetSocketAddress resolved = addr.isUnresolved() ? new InetSocketAddress(InetAddress.getByName(addr.getHostName()), port) : new InetSocketAddress(addr.getAddress(), port);
                    if (!resolved.equals(locAddr)) continue;
                    return true;
                }
                catch (UnknownHostException e) {
                    this.getExceptionRegistry().onException(e.getMessage(), e);
                }
            }
        }
        return false;
    }

    boolean isSslEnabled() {
        return this.ignite().configuration().getSslContextFactory() != null;
    }

    @Override
    public void clientReconnect() throws IgniteSpiException {
        this.impl.reconnect();
    }

    @Override
    public boolean knownNode(UUID nodeId) {
        return this.getNode0(nodeId) != null;
    }

    @Override
    public boolean clientReconnectSupported() {
        return !this.clientReconnectDisabled;
    }

    @Override
    public boolean supportsCommunicationFailureResolve() {
        return false;
    }

    @Override
    public void resolveCommunicationFailure(ClusterNode node, Exception err2) {
        throw new UnsupportedOperationException();
    }

    public int clientWorkerCount() {
        return ((ServerImpl)this.impl).clientMsgWorkers.size();
    }

    void forceNextNodeFailure() {
        ((ServerImpl)this.impl).forceNextNodeFailure();
    }

    public void addSendMessageListener(IgniteInClosure<TcpDiscoveryAbstractMessage> lsnr) {
        this.sndMsgLsnrs.add(lsnr);
    }

    @Override
    public void setInternalListener(IgniteDiscoverySpiInternalListener lsnr) {
        this.internalLsnr = lsnr;
    }

    public void removeSendMessageListener(IgniteInClosure<TcpDiscoveryAbstractMessage> lsnr) {
        this.sndMsgLsnrs.remove(lsnr);
    }

    public void addIncomeConnectionListener(IgniteInClosure<Socket> lsnr) {
        this.incomeConnLsnrs.add(lsnr);
    }

    public void removeIncomeConnectionListener(IgniteInClosure<Socket> lsnr) {
        this.incomeConnLsnrs.remove(lsnr);
    }

    public void waitForClientMessagePrecessed() {
        if (this.impl instanceof ClientImpl) {
            ((ClientImpl)this.impl).waitForClientMessagePrecessed();
        }
    }

    @Override
    public void simulateNodeFailure() {
        this.impl.simulateNodeFailure();
    }

    public void brakeConnection() {
        this.impl.brakeConnection();
    }

    public boolean isLocalNodeCoordinator() {
        if (this.impl instanceof ServerImpl) {
            return ((ServerImpl)this.impl).isLocalNodeCoordinator();
        }
        return false;
    }

    protected Marshaller marshaller() {
        MarshallerUtils.setNodeName(this.marsh, this.igniteInstanceName);
        return this.marsh;
    }

    @Override
    public TcpDiscoverySpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(TcpDiscoverySpi.class, this);
    }

    private class TcpDiscoverySpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements TcpDiscoverySpiMBean {
        TcpDiscoverySpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        @Override
        public String getSpiState() {
            return TcpDiscoverySpi.this.impl.getSpiState();
        }

        @Override
        public int getMessageWorkerQueueSize() {
            return TcpDiscoverySpi.this.impl.getMessageWorkerQueueSize();
        }

        @Override
        @Nullable
        public UUID getCoordinator() {
            return TcpDiscoverySpi.this.impl.getCoordinator();
        }

        @Override
        @Nullable
        public String getCoordinatorNodeFormatted() {
            return String.valueOf(TcpDiscoverySpi.this.impl.getNode(TcpDiscoverySpi.this.impl.getCoordinator()));
        }

        @Override
        public String getLocalNodeFormatted() {
            return String.valueOf(TcpDiscoverySpi.this.getLocalNode());
        }

        @Override
        public void dumpDebugInfo() {
            TcpDiscoverySpi.this.impl.dumpDebugInfo(TcpDiscoverySpi.this.log);
        }

        @Override
        public long getSocketTimeout() {
            return TcpDiscoverySpi.this.getSocketTimeout();
        }

        @Override
        public long getMaxAckTimeout() {
            return TcpDiscoverySpi.this.getMaxAckTimeout();
        }

        @Override
        public long getAckTimeout() {
            return TcpDiscoverySpi.this.getAckTimeout();
        }

        @Override
        public long getNetworkTimeout() {
            return TcpDiscoverySpi.this.getNetworkTimeout();
        }

        @Override
        public long getJoinTimeout() {
            return TcpDiscoverySpi.this.getJoinTimeout();
        }

        @Override
        public int getLocalPort() {
            return TcpDiscoverySpi.this.getLocalPort();
        }

        @Override
        public int getLocalPortRange() {
            return TcpDiscoverySpi.this.getLocalPortRange();
        }

        @Override
        public long getIpFinderCleanFrequency() {
            return TcpDiscoverySpi.this.getIpFinderCleanFrequency();
        }

        @Override
        public int getThreadPriority() {
            return TcpDiscoverySpi.this.getThreadPriority();
        }

        @Override
        public long getStatisticsPrintFrequency() {
            return TcpDiscoverySpi.this.getStatisticsPrintFrequency();
        }

        @Override
        public String getIpFinderFormatted() {
            return TcpDiscoverySpi.this.getIpFinderFormatted();
        }

        @Override
        public int getReconnectCount() {
            return TcpDiscoverySpi.this.getReconnectCount();
        }

        @Override
        public long getConnectionCheckInterval() {
            return TcpDiscoverySpi.this.impl.connectionCheckInterval();
        }

        @Override
        public boolean isClientMode() {
            return TcpDiscoverySpi.this.isClientMode();
        }

        @Override
        public long getNodesJoined() {
            return TcpDiscoverySpi.this.getNodesJoined();
        }

        @Override
        public long getNodesLeft() {
            return TcpDiscoverySpi.this.getNodesLeft();
        }

        @Override
        public long getNodesFailed() {
            return TcpDiscoverySpi.this.getNodesFailed();
        }

        @Override
        public long getPendingMessagesRegistered() {
            return TcpDiscoverySpi.this.getPendingMessagesRegistered();
        }

        @Override
        public long getPendingMessagesDiscarded() {
            return TcpDiscoverySpi.this.stats.pendingMessagesDiscarded();
        }

        @Override
        public long getAvgMessageProcessingTime() {
            return TcpDiscoverySpi.this.getAvgMessageProcessingTime();
        }

        @Override
        public long getMaxMessageProcessingTime() {
            return TcpDiscoverySpi.this.getMaxMessageProcessingTime();
        }

        @Override
        public int getTotalReceivedMessages() {
            return TcpDiscoverySpi.this.getTotalReceivedMessages();
        }

        @Override
        public Map<String, Integer> getReceivedMessages() {
            return TcpDiscoverySpi.this.getReceivedMessages();
        }

        @Override
        public int getTotalProcessedMessages() {
            return TcpDiscoverySpi.this.getTotalProcessedMessages();
        }

        @Override
        public Map<String, Integer> getProcessedMessages() {
            return TcpDiscoverySpi.this.getProcessedMessages();
        }

        @Override
        public long getCoordinatorSinceTimestamp() {
            return TcpDiscoverySpi.this.getCoordinatorSinceTimestamp();
        }

        @Override
        public void checkRingLatency(int maxHops) {
            TcpDiscoverySpi.this.impl.checkRingLatency(maxHops);
        }

        @Override
        public long getCurrentTopologyVersion() {
            return TcpDiscoverySpi.this.impl.getCurrentTopologyVersion();
        }

        @Override
        public void dumpRingStructure() {
            TcpDiscoverySpi.this.impl.dumpRingStructure(TcpDiscoverySpi.this.log);
        }
    }

    private class SocketTimeoutObject
    implements IgniteSpiTimeoutObject {
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private final Socket sock;
        private final long endTime;
        private final AtomicBoolean done = new AtomicBoolean();

        SocketTimeoutObject(Socket sock, long endTime) {
            assert (sock != null);
            assert (endTime > 0L);
            this.sock = sock;
            this.endTime = endTime;
        }

        boolean cancel() {
            return this.done.compareAndSet(false, true);
        }

        @Override
        public void onTimeout() {
            if (this.done.compareAndSet(false, true)) {
                U.closeQuiet(this.sock);
                LT.warn(TcpDiscoverySpi.this.log, "Socket write has timed out (consider increasing " + (TcpDiscoverySpi.this.failureDetectionTimeoutEnabled() ? "'IgniteConfiguration.failureDetectionTimeout' configuration property) [failureDetectionTimeout=" + TcpDiscoverySpi.this.failureDetectionTimeout() : "'sockTimeout' configuration property) [sockTimeout=" + TcpDiscoverySpi.this.sockTimeout) + ", rmtAddr=" + this.sock.getRemoteSocketAddress() + ", rmtPort=" + this.sock.getPort() + ", sockTimeout=" + TcpDiscoverySpi.this.sockTimeout + ']');
                TcpDiscoverySpi.this.stats.onSocketTimeout();
            }
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        @Override
        public IgniteUuid id() {
            return this.id;
        }

        public String toString() {
            return S.toString(SocketTimeoutObject.class, this);
        }
    }
}

