/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.local;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskName;
import org.apache.ignite.internal.util.GridAnnotationsCache;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.deployment.DeploymentListener;
import org.apache.ignite.spi.deployment.DeploymentResource;
import org.apache.ignite.spi.deployment.DeploymentResourceAdapter;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.apache.ignite.spi.deployment.IgnoreIfPeerClassLoadingDisabled;
import org.apache.ignite.spi.deployment.local.LocalDeploymentSpiMBean;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=false)
@IgnoreIfPeerClassLoadingDisabled
public class LocalDeploymentSpi
extends IgniteSpiAdapter
implements DeploymentSpi {
    public static final String IGNITE_DEPLOYMENT_ADDITIONAL_CHECK = "IGNITE.DEPLOYMENT.ADDITIONAL.CHECK";
    private static final boolean ENABLE_IGNITE_DEPLOYMENT_ADDITIONAL_CHECK = IgniteSystemProperties.getBoolean("IGNITE.DEPLOYMENT.ADDITIONAL.CHECK");
    @LoggerResource
    private IgniteLogger log;
    private ConcurrentLinkedHashMap<ClassLoader, ConcurrentMap<String, String>> ldrRsrcs = new ConcurrentLinkedHashMap(16, 0.75f, 64);
    private volatile DeploymentListener lsnr;

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.startStopwatch();
        this.registerMBean(igniteInstanceName, new LocalDeploymentSpiMBeanImpl(this), LocalDeploymentSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        for (ClassLoader ldr : this.ldrRsrcs.descendingKeySet()) {
            this.onClassLoaderReleased(ldr);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    @Nullable
    public DeploymentResource findResource(String rsrcName) {
        assert (rsrcName != null);
        for (Map.Entry<ClassLoader, ConcurrentMap<String, String>> e : this.ldrRsrcs.descendingEntrySet()) {
            ClassLoader ldr = e.getKey();
            ConcurrentMap<String, String> rsrcs = e.getValue();
            String clsName = (String)rsrcs.get(rsrcName);
            if (clsName == null) continue;
            rsrcName = this.getResourceName(clsName, rsrcs);
            assert (clsName != null);
            try {
                Class<?> cls = Class.forName(clsName, true, ldr);
                assert (cls != null);
                return new DeploymentResourceAdapter(rsrcName, cls, ldr);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private String getResourceName(String clsName, Map<String, String> rsrcs) {
        String rsrcName = clsName;
        for (Map.Entry<String, String> e : rsrcs.entrySet()) {
            if (!e.getValue().equals(clsName) || e.getKey().equals(clsName)) continue;
            rsrcName = e.getKey();
            break;
        }
        return rsrcName;
    }

    @Override
    public boolean register(ClassLoader ldr, Class<?> rsrc) throws IgniteSpiException {
        ConcurrentMap old;
        ConcurrentMap clsLdrRsrcs;
        assert (ldr != null);
        assert (rsrc != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registering [ldrRsrcs=" + this.ldrRsrcs + ", ldr=" + ldr + ", rsrc=" + rsrc + ']');
        }
        if ((clsLdrRsrcs = this.ldrRsrcs.getSafe(ldr)) == null && (old = (ConcurrentMap)this.ldrRsrcs.putIfAbsent(ldr, clsLdrRsrcs = new ConcurrentHashMap<String, String>())) != null) {
            clsLdrRsrcs = old;
        }
        Map<String, String> newRsrcs = this.addResource(ldr, clsLdrRsrcs, rsrc);
        LinkedList<ClassLoader> rmvClsLdrs = null;
        if (!F.isEmpty(newRsrcs)) {
            rmvClsLdrs = new LinkedList<ClassLoader>();
            this.removeResources(ldr, newRsrcs, rmvClsLdrs);
        }
        if (rmvClsLdrs != null) {
            for (ClassLoader cldLdr : rmvClsLdrs) {
                this.onClassLoaderReleased(cldLdr);
            }
        }
        return !F.isEmpty(newRsrcs);
    }

    @Override
    public boolean unregister(String rsrcName) {
        LinkedList<ClassLoader> rmvClsLdrs = new LinkedList<ClassLoader>();
        HashMap<String, String> rsrcs = U.newHashMap(1);
        rsrcs.put(rsrcName, rsrcName);
        boolean rmv = this.removeResources(null, rsrcs, rmvClsLdrs);
        for (ClassLoader cldLdr : rmvClsLdrs) {
            this.onClassLoaderReleased(cldLdr);
        }
        return rmv;
    }

    @Nullable
    private Map<String, String> addResource(ClassLoader ldr, ConcurrentMap<String, String> ldrRsrcs, Class<?> cls) throws IgniteSpiException {
        ComputeTaskName nameAnn;
        assert (ldr != null);
        assert (ldrRsrcs != null);
        assert (cls != null);
        HashMap<String, String> regRsrcs = U.newHashMap(2);
        String alias = null;
        if (ComputeTask.class.isAssignableFrom(cls) && (nameAnn = GridAnnotationsCache.getAnnotation(cls, ComputeTaskName.class)) != null) {
            alias = nameAnn.value();
        }
        if (alias != null) {
            regRsrcs.put(alias, cls.getName());
        }
        regRsrcs.put(cls.getName(), cls.getName());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resources to register: " + regRsrcs);
        }
        HashMap newRsrcs = null;
        for (Map.Entry entry2 : regRsrcs.entrySet()) {
            String oldCls = ldrRsrcs.putIfAbsent((String)entry2.getKey(), (String)entry2.getValue());
            if (oldCls != null) {
                if (oldCls.equals(entry2.getValue())) continue;
                throw new IgniteSpiException("Failed to register resources with given task name (found another class with same task name in the same class loader) [taskName=" + (String)entry2.getKey() + ", existingCls=" + oldCls + ", newCls=" + (String)entry2.getValue() + ", ldr=" + ldr + ']');
            }
            if (newRsrcs == null) {
                newRsrcs = U.newHashMap(regRsrcs.size());
            }
            newRsrcs.put(entry2.getKey(), entry2.getValue());
        }
        if (newRsrcs != null) {
            ldrRsrcs.putAll(newRsrcs);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("New resources: " + newRsrcs);
        }
        return newRsrcs;
    }

    private boolean removeResources(@Nullable ClassLoader clsLdrToIgnore, Map<String, String> rsrcs, Collection<ClassLoader> rmvClsLdrs) {
        assert (rsrcs != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing resources [clsLdrToIgnore=" + clsLdrToIgnore + ", rsrcs=" + rsrcs + ']');
        }
        boolean res = false;
        block0: for (Map.Entry<ClassLoader, ConcurrentMap<String, String>> e : this.ldrRsrcs.descendingEntrySet()) {
            ClassLoader ldr = e.getKey();
            if (clsLdrToIgnore != null && ldr.equals(clsLdrToIgnore)) continue;
            Map clsLdrRsrcs = e.getValue();
            boolean isRmv = false;
            for (String string2 : rsrcs.keySet()) {
                if (!clsLdrRsrcs.containsKey(string2) || !this.ldrRsrcs.remove(ldr, clsLdrRsrcs)) continue;
                rmvClsLdrs.add(ldr);
                isRmv = true;
                res = true;
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Removed resources [ldr=" + ldr + ", rsrcs=" + clsLdrRsrcs + ']');
                break;
            }
            if (isRmv) continue;
            for (Map.Entry entry2 : rsrcs.entrySet()) {
                if (!((String)entry2.getKey()).equals(entry2.getValue()) || !this.isResourceExist(ldr, (String)entry2.getKey()) || U.hasParent(clsLdrToIgnore, ldr) || ENABLE_IGNITE_DEPLOYMENT_ADDITIONAL_CHECK && !clsLdrRsrcs.containsKey(entry2.getKey()) || !this.ldrRsrcs.remove(ldr, clsLdrRsrcs)) continue;
                rmvClsLdrs.add(ldr);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Removed resources after checking existence [ldr=" + ldr + ", clsLdrRsrcs=" + clsLdrRsrcs + ", rsrcs=" + rsrcs + ']');
                }
                res = true;
                continue block0;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isResourceExist(ClassLoader ldr, String clsName) {
        assert (ldr != null);
        assert (clsName != null);
        String rsrcName = clsName.replaceAll("\\.", "/") + ".class";
        InputStream in = null;
        try {
            in = ldr.getResourceAsStream(rsrcName);
            boolean bl = in != null;
            return bl;
        }
        finally {
            U.closeQuiet(in);
        }
    }

    private void onClassLoaderReleased(ClassLoader clsLdr) {
        DeploymentListener tmp = this.lsnr;
        if (tmp != null) {
            tmp.onUnregistered(clsLdr);
        }
    }

    @Override
    public void setListener(DeploymentListener lsnr) {
        this.lsnr = lsnr;
    }

    @Override
    public LocalDeploymentSpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(LocalDeploymentSpi.class, this);
    }

    private class LocalDeploymentSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements LocalDeploymentSpiMBean {
        LocalDeploymentSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }
    }
}

