/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.messages;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;

public class RecoveryLastReceivedMessage
implements Message {
    private static final long serialVersionUID = 0L;
    public static final long ALREADY_CONNECTED = -1L;
    public static final long NODE_STOPPING = -2L;
    public static final long NEED_WAIT = -3L;
    private static final int MESSAGE_SIZE = 8;
    public static final int MESSAGE_FULL_SIZE = 10;
    private long rcvCnt;

    public RecoveryLastReceivedMessage() {
    }

    public RecoveryLastReceivedMessage(long rcvCnt) {
        this.rcvCnt = rcvCnt;
    }

    public long received() {
        return this.rcvCnt;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        if (buf.remaining() < 10) {
            return false;
        }
        TcpCommunicationSpi.writeMessageType(buf, this.directType());
        buf.putLong(this.rcvCnt);
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        if (buf.remaining() < 8) {
            return false;
        }
        this.rcvCnt = buf.getLong();
        return true;
    }

    @Override
    public short directType() {
        return -2;
    }

    @Override
    public byte fieldsCount() {
        return 0;
    }

    public String toString() {
        return S.toString(RecoveryLastReceivedMessage.class, this);
    }
}

