/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.checkpoint.sharedfs;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.checkpoint.CheckpointListener;
import org.apache.ignite.spi.checkpoint.sharedfs.SharedFsTimeData;
import org.apache.ignite.spi.checkpoint.sharedfs.SharedFsUtils;

class SharedFsTimeoutTask
extends IgniteSpiThread {
    private Map<File, SharedFsTimeData> files = new HashMap<File, SharedFsTimeData>();
    private IgniteLogger log;
    private Marshaller marshaller;
    private final Object mux = new Object();
    private CheckpointListener lsnr;

    SharedFsTimeoutTask(String igniteInstanceName, Marshaller marshaller, IgniteLogger log2) {
        super(igniteInstanceName, "grid-sharedfs-timeout-worker", log2);
        assert (marshaller != null);
        assert (log2 != null);
        this.marshaller = marshaller;
        this.log = log2.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void body() throws InterruptedException {
        Object object;
        long nextTime = 0L;
        HashSet<String> rmvKeys = new HashSet<String>();
        while (!this.isInterrupted()) {
            rmvKeys.clear();
            object = this.mux;
            synchronized (object) {
                if (nextTime != 0L) {
                    long delay;
                    if (nextTime == -1L) {
                        delay = 5000L;
                    } else {
                        assert (nextTime > 0L);
                        delay = nextTime - U.currentTimeMillis();
                    }
                    while (delay > 0L) {
                        this.mux.wait(delay);
                        delay = nextTime - U.currentTimeMillis();
                    }
                }
                HashMap<File, SharedFsTimeData> snapshot2 = new HashMap<File, SharedFsTimeData>(this.files);
                long now = U.currentTimeMillis();
                nextTime = -1L;
                for (Map.Entry entry2 : snapshot2.entrySet()) {
                    SharedFsTimeData timeData;
                    File file;
                    block20: {
                        file = (File)entry2.getKey();
                        timeData = (SharedFsTimeData)entry2.getValue();
                        try {
                            if (timeData.getLastAccessTime() == file.lastModified()) break block20;
                            timeData.setExpireTime(SharedFsUtils.read(file, this.marshaller, this.log).getExpireTime());
                        }
                        catch (IgniteCheckedException e) {
                            U.error(this.log, "Failed to marshal/unmarshal in checkpoint file: " + file.getAbsolutePath(), e);
                            continue;
                        }
                        catch (IOException e) {
                            if (!file.exists()) {
                                this.files.remove(file);
                                rmvKeys.add(timeData.getKey());
                                continue;
                            }
                            U.error(this.log, "Failed to read checkpoint file: " + file.getAbsolutePath(), e);
                            continue;
                        }
                    }
                    if (timeData.getExpireTime() <= 0L) continue;
                    if (timeData.getExpireTime() <= now) {
                        if (!file.delete() && file.exists()) {
                            U.error(this.log, "Failed to delete check point file by timeout: " + file.getAbsolutePath());
                            continue;
                        }
                        this.files.remove(file);
                        rmvKeys.add(timeData.getKey());
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("File was deleted by timeout: " + file.getAbsolutePath());
                        continue;
                    }
                    if (timeData.getExpireTime() >= nextTime && nextTime != -1L) continue;
                    nextTime = timeData.getExpireTime();
                }
            }
            CheckpointListener lsnr = this.lsnr;
            if (lsnr == null) continue;
            for (String key : rmvKeys) {
                lsnr.onCheckpointRemoved(key);
            }
        }
        object = this.mux;
        synchronized (object) {
            this.files.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(File file, SharedFsTimeData timeData) {
        assert (file != null);
        assert (timeData != null);
        Object object = this.mux;
        synchronized (object) {
            this.files.put(file, timeData);
            this.mux.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Map<File, SharedFsTimeData> newFiles) {
        assert (newFiles != null);
        Object object = this.mux;
        synchronized (object) {
            this.files.putAll(newFiles);
            this.mux.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(File file) {
        assert (file != null);
        Object object = this.mux;
        synchronized (object) {
            this.files.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Iterable<File> delFiles) {
        assert (delFiles != null);
        Object object = this.mux;
        synchronized (object) {
            for (File file : delFiles) {
                this.files.remove(file);
            }
        }
    }

    void setCheckpointListener(CheckpointListener lsnr) {
        this.lsnr = lsnr;
    }

    @Override
    public String toString() {
        return S.toString(SharedFsTimeoutTask.class, this);
    }
}

