/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller.jdk;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.io.GridByteArrayInputStream;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.AbstractNodeNameAwareMarshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshallerInputStreamWrapper;
import org.apache.ignite.marshaller.jdk.JdkMarshallerObjectInputStream;
import org.apache.ignite.marshaller.jdk.JdkMarshallerObjectOutputStream;
import org.apache.ignite.marshaller.jdk.JdkMarshallerOutputStreamWrapper;
import org.jetbrains.annotations.Nullable;

public class JdkMarshaller
extends AbstractNodeNameAwareMarshaller {
    private final IgnitePredicate<String> clsFilter;

    public JdkMarshaller() {
        this(null);
    }

    public JdkMarshaller(IgnitePredicate<String> clsFilter) {
        this.clsFilter = clsFilter;
    }

    @Override
    protected void marshal0(@Nullable Object obj, OutputStream out) throws IgniteCheckedException {
        assert (out != null);
        JdkMarshallerObjectOutputStream objOut = null;
        try {
            objOut = new JdkMarshallerObjectOutputStream(new JdkMarshallerOutputStreamWrapper(out));
            objOut.writeObject(obj);
            objOut.flush();
        }
        catch (Exception e) {
            try {
                throw new IgniteCheckedException("Failed to serialize object: " + obj, e);
            }
            catch (Throwable throwable2) {
                U.closeQuiet(objOut);
                throw throwable2;
            }
        }
        U.closeQuiet(objOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] marshal0(@Nullable Object obj) throws IgniteCheckedException {
        GridByteArrayOutputStream out = null;
        try {
            out = new GridByteArrayOutputStream(512);
            this.marshal(obj, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            U.close(out, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> T unmarshal0(InputStream in, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        Object object;
        assert (in != null);
        if (clsLdr == null) {
            clsLdr = this.getClass().getClassLoader();
        }
        JdkMarshallerObjectInputStream objIn = null;
        try {
            objIn = new JdkMarshallerObjectInputStream(new JdkMarshallerInputStreamWrapper(in), clsLdr, this.clsFilter);
            object = objIn.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new IgniteCheckedException("Failed to find class with given class loader for unmarshalling (make sure same versions of all classes are available on all nodes or enable peer-class-loading) [clsLdr=" + clsLdr + ", cls=" + e.getMessage() + "]", e);
                catch (Exception e2) {
                    throw new IgniteCheckedException("Failed to deserialize object with given class loader: " + clsLdr, e2);
                }
            }
            catch (Throwable throwable2) {
                U.closeQuiet(objIn);
                throw throwable2;
            }
        }
        U.closeQuiet(objIn);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T unmarshal0(byte[] arr, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        Object t;
        GridByteArrayInputStream in = null;
        try {
            in = new GridByteArrayInputStream(arr, 0, arr.length);
            t = this.unmarshal(in, clsLdr);
        }
        catch (Throwable throwable2) {
            U.close(in, null);
            throw throwable2;
        }
        U.close(in, null);
        return t;
    }

    @Override
    public void onUndeploy(ClassLoader ldr) {
    }

    public String toString() {
        return S.toString(JdkMarshaller.class, this);
    }
}

