/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JavaLoggerFormatter
extends Formatter {
    public static final String ANONYMOUS_LOGGER_NAME = "UNKNOWN";
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss,SSS");
        }
    };

    @Override
    public String format(LogRecord record2) {
        String threadName = Thread.currentThread().getName();
        String logName = record2.getLoggerName();
        if (logName == null) {
            logName = ANONYMOUS_LOGGER_NAME;
        } else if (logName.contains(".")) {
            logName = logName.substring(logName.lastIndexOf(46) + 1);
        }
        String ex = null;
        if (record2.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record2.getThrown().printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            ex = "\n" + stackTrace;
        }
        return "[" + DATE_FORMATTER.get().format(new Date(record2.getMillis())) + "][" + record2.getLevel() + "][" + threadName + "][" + logName + "] " + this.formatMessage(record2) + (ex == null ? "\n" : ex);
    }

    public String toString() {
        return S.toString(JavaLoggerFormatter.class, this);
    }
}

