/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorValidateIndexesTask
extends VisorMultiNodeTask<VisorValidateIndexesTaskArg, VisorValidateIndexesTaskResult, VisorValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected VisorValidateIndexesTaskResult reduce0(List<ComputeJobResult> list2) throws IgniteException {
        HashMap<UUID, Exception> exceptions2 = new HashMap<UUID, Exception>();
        HashMap<UUID, VisorValidateIndexesJobResult> jobResults = new HashMap<UUID, VisorValidateIndexesJobResult>();
        for (ComputeJobResult res : list2) {
            if (res.getException() != null) {
                exceptions2.put(res.getNode().id(), res.getException());
                continue;
            }
            jobResults.put(res.getNode().id(), (VisorValidateIndexesJobResult)res.getData());
        }
        return new VisorValidateIndexesTaskResult(jobResults, exceptions2);
    }

    @Override
    protected VisorJob<VisorValidateIndexesTaskArg, VisorValidateIndexesJobResult> job(VisorValidateIndexesTaskArg arg) {
        return new VisorValidateIndexesJob(arg, this.debug);
    }

    private static class VisorValidateIndexesJob
    extends VisorJob<VisorValidateIndexesTaskArg, VisorValidateIndexesJobResult> {
        private static final long serialVersionUID = 0L;

        protected VisorValidateIndexesJob(@Nullable VisorValidateIndexesTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorValidateIndexesJobResult run(@Nullable VisorValidateIndexesTaskArg arg) throws IgniteException {
            try {
                ValidateIndexesClosure clo = new ValidateIndexesClosure(arg.getCaches(), arg.getCheckFirst(), arg.getCheckThrough());
                this.ignite.context().resource().injectGeneric(clo);
                return clo.call();
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(VisorValidateIndexesJob.class, this);
        }
    }
}

