/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.processors.cache.verify.CollectConflictPartitionKeysTask;
import org.apache.ignite.internal.processors.cache.verify.PartitionEntryHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecord;
import org.apache.ignite.internal.processors.cache.verify.RetrieveConflictPartitionValuesTask;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.verify.VisorIdleAnalyzeTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleAnalyzeTaskResult;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;

@GridInternal
public class VisorIdleAnalyzeTask
extends VisorOneNodeTask<VisorIdleAnalyzeTaskArg, VisorIdleAnalyzeTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorIdleAnalyzeTaskArg, VisorIdleAnalyzeTaskResult> job(VisorIdleAnalyzeTaskArg arg) {
        return new VisorIdleVerifyJob(arg, this.debug);
    }

    private static class VisorIdleVerifyJob
    extends VisorJob<VisorIdleAnalyzeTaskArg, VisorIdleAnalyzeTaskResult> {
        private static final long serialVersionUID = 0L;
        private ComputeTaskFuture<Map<PartitionHashRecord, List<PartitionEntryHashRecord>>> conflictKeysFut;
        private ComputeTaskFuture<Map<PartitionHashRecord, List<PartitionEntryHashRecord>>> conflictValsFut;
        @JobContextResource
        protected transient ComputeJobContext jobCtx;

        private VisorIdleVerifyJob(VisorIdleAnalyzeTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorIdleAnalyzeTaskResult run(VisorIdleAnalyzeTaskArg arg) throws IgniteException {
            Map<PartitionHashRecord, List<PartitionEntryHashRecord>> conflictKeys;
            if (this.conflictKeysFut == null) {
                this.conflictKeysFut = this.ignite.compute().executeAsync(CollectConflictPartitionKeysTask.class, arg.getPartitionKey());
                if (!this.conflictKeysFut.isDone()) {
                    this.jobCtx.holdcc();
                    this.conflictKeysFut.listen(new IgniteInClosure<IgniteFuture<Map<PartitionHashRecord, List<PartitionEntryHashRecord>>>>(){

                        @Override
                        public void apply(IgniteFuture<Map<PartitionHashRecord, List<PartitionEntryHashRecord>>> f2) {
                            jobCtx.callcc();
                        }
                    });
                    return null;
                }
            }
            if ((conflictKeys = this.conflictKeysFut.get()).isEmpty()) {
                return new VisorIdleAnalyzeTaskResult(Collections.emptyMap());
            }
            if (this.conflictValsFut == null) {
                this.conflictValsFut = this.ignite.compute().executeAsync(RetrieveConflictPartitionValuesTask.class, conflictKeys);
                if (!this.conflictValsFut.isDone()) {
                    this.jobCtx.holdcc();
                    this.conflictKeysFut.listen(new IgniteInClosure<IgniteFuture<Map<PartitionHashRecord, List<PartitionEntryHashRecord>>>>(){

                        @Override
                        public void apply(IgniteFuture<Map<PartitionHashRecord, List<PartitionEntryHashRecord>>> f2) {
                            jobCtx.callcc();
                        }
                    });
                    return null;
                }
            }
            return new VisorIdleAnalyzeTaskResult(this.conflictValsFut.get());
        }

        public String toString() {
            return S.toString(VisorIdleVerifyJob.class, this);
        }
    }
}

