/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.processors.cache.verify.ContentionInfo;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.verify.VisorContentionJobResult;

public class VisorContentionTaskResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private List<VisorContentionJobResult> clusterInfos;
    private Map<UUID, Exception> exceptions;

    public VisorContentionTaskResult(List<VisorContentionJobResult> clusterInfos, Map<UUID, Exception> exceptions2) {
        this.clusterInfos = clusterInfos;
        this.exceptions = exceptions2;
    }

    public VisorContentionTaskResult() {
    }

    public Collection<VisorContentionJobResult> jobResults() {
        return this.clusterInfos;
    }

    public Collection<ContentionInfo> getInfos() {
        return this.clusterInfos.stream().map(VisorContentionJobResult::info).collect(Collectors.toList());
    }

    public Map<UUID, Exception> exceptions() {
        return this.exceptions;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.clusterInfos);
        U.writeMap(out, this.exceptions);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.clusterInfos = U.readList(in);
        this.exceptions = U.readMap(in);
    }

    public String toString() {
        return S.toString(VisorContentionTaskResult.class, this);
    }
}

