/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;

public class ValidateIndexesPartitionResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long updateCntr;
    private long size;
    private boolean isPrimary;
    @GridToStringInclude
    private Object consistentId;
    @GridToStringExclude
    private List<IndexValidationIssue> issues = new ArrayList<IndexValidationIssue>(10);
    @GridToStringExclude
    private String sqlIdxName;

    public ValidateIndexesPartitionResult() {
    }

    public ValidateIndexesPartitionResult(long updateCntr, long size2, boolean isPrimary, Object consistentId, String sqlIdxName) {
        this.updateCntr = updateCntr;
        this.size = size2;
        this.isPrimary = isPrimary;
        this.consistentId = consistentId;
        this.sqlIdxName = sqlIdxName;
    }

    public long updateCntr() {
        return this.updateCntr;
    }

    public long size() {
        return this.size;
    }

    public boolean primary() {
        return this.isPrimary;
    }

    public Object consistentId() {
        return this.consistentId;
    }

    public List<IndexValidationIssue> issues() {
        return this.issues;
    }

    public String sqlIndexName() {
        return this.sqlIdxName;
    }

    public boolean reportIssue(IndexValidationIssue t) {
        if (this.issues.size() >= 10) {
            return true;
        }
        this.issues.add(t);
        return false;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.updateCntr);
        out.writeLong(this.size);
        out.writeBoolean(this.isPrimary);
        out.writeObject(this.consistentId);
        U.writeCollection(out, this.issues);
        U.writeString(out, this.sqlIdxName);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.updateCntr = in.readLong();
        this.size = in.readLong();
        this.isPrimary = in.readBoolean();
        this.consistentId = in.readObject();
        this.issues = U.readList(in);
        if (protoVer >= 2) {
            this.sqlIdxName = U.readString(in);
        }
    }

    public String toString() {
        return this.sqlIdxName == null ? S.toString(ValidateIndexesPartitionResult.class, this) : ValidateIndexesPartitionResult.class.getSimpleName() + " [consistentId=" + this.consistentId + ", sqlIdxName=" + this.sqlIdxName + "]";
    }
}

