/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.result.SearchRow;

public class ValidateIndexesClosure
implements IgniteCallable<VisorValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private transient IgniteEx ignite;
    @LoggerResource
    private IgniteLogger log;
    private Set<String> cacheNames;
    private final int checkFirst;
    private final int checkThrough;
    private final AtomicInteger processedPartitions = new AtomicInteger(0);
    private volatile int totalPartitions;
    private final AtomicInteger processedIndexes = new AtomicInteger(0);
    private volatile int totalIndexes;
    private final AtomicLong lastProgressPrintTs = new AtomicLong(0L);
    private volatile ExecutorService calcExecutor;

    public ValidateIndexesClosure(Set<String> cacheNames, int checkFirst, int checkThrough) {
        this.cacheNames = cacheNames;
        this.checkFirst = checkFirst;
        this.checkThrough = checkThrough;
    }

    @Override
    public VisorValidateIndexesJobResult call() throws Exception {
        this.calcExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            VisorValidateIndexesJobResult visorValidateIndexesJobResult = this.call0();
            return visorValidateIndexesJobResult;
        }
        finally {
            this.calcExecutor.shutdown();
        }
    }

    private VisorValidateIndexesJobResult call0() throws Exception {
        HashSet<Integer> grpIds = new HashSet<Integer>();
        HashSet<String> missingCaches = new HashSet<String>();
        if (this.cacheNames != null) {
            for (String string2 : this.cacheNames) {
                DynamicCacheDescriptor dynamicCacheDescriptor = this.ignite.context().cache().cacheDescriptor(string2);
                if (dynamicCacheDescriptor == null) {
                    missingCaches.add(string2);
                    continue;
                }
                grpIds.add(dynamicCacheDescriptor.groupId());
            }
            if (!missingCaches.isEmpty()) {
                StringBuilder strBuilder = new StringBuilder("The following caches do not exist: ");
                for (String string3 : missingCaches) {
                    strBuilder.append(string3).append(", ");
                }
                strBuilder.delete(strBuilder.length() - 2, strBuilder.length());
                throw new IgniteException(strBuilder.toString());
            }
        } else {
            Collection<CacheGroupContext> groups = this.ignite.context().cache().cacheGroups();
            for (CacheGroupContext cacheGroupContext : groups) {
                if (cacheGroupContext.systemCache() || cacheGroupContext.isLocal()) continue;
                grpIds.add(cacheGroupContext.groupId());
            }
        }
        ArrayList<Future<Map<PartitionKey, ValidateIndexesPartitionResult>>> procPartFutures = new ArrayList<Future<Map<PartitionKey, ValidateIndexesPartitionResult>>>();
        ArrayList<Future<Map<String, ValidateIndexesPartitionResult>>> arrayList = new ArrayList<Future<Map<String, ValidateIndexesPartitionResult>>>();
        ArrayList<T2<CacheGroupContext, GridDhtLocalPartition>> arrayList2 = new ArrayList<T2<CacheGroupContext, GridDhtLocalPartition>>();
        ArrayList<T2<GridCacheContext, Index>> idxArgs = new ArrayList<T2<GridCacheContext, Index>>();
        for (Integer n : grpIds) {
            CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(n);
            if (grpCtx == null) continue;
            List<GridDhtLocalPartition> parts = grpCtx.topology().localPartitions();
            for (GridDhtLocalPartition part : parts) {
                arrayList2.add(new T2<CacheGroupContext, GridDhtLocalPartition>(grpCtx, part));
            }
            GridQueryProcessor qry = this.ignite.context().query();
            IgniteH2Indexing indexing = (IgniteH2Indexing)qry.getIndexing();
            for (GridCacheContext ctx : grpCtx.caches()) {
                Collection<GridQueryTypeDescriptor> types2 = qry.types(ctx.name());
                if (F.isEmpty(types2)) continue;
                for (GridQueryTypeDescriptor type : types2) {
                    GridH2Table gridH2Tbl = indexing.dataTable(ctx.name(), type.tableName());
                    if (gridH2Tbl == null) continue;
                    ArrayList<Index> indexes = gridH2Tbl.getIndexes();
                    for (Index idx : indexes) {
                        idxArgs.add(new T2<GridCacheContext, Index>(ctx, idx));
                    }
                }
            }
        }
        Collections.shuffle(arrayList2);
        Collections.shuffle(idxArgs);
        for (T2 t2 : arrayList2) {
            procPartFutures.add(this.processPartitionAsync((CacheGroupContext)t2.get1(), (GridDhtLocalPartition)t2.get2()));
        }
        for (T2 t2 : idxArgs) {
            arrayList.add(this.processIndexAsync((GridCacheContext)t2.get1(), (Index)t2.get2()));
        }
        this.totalPartitions = procPartFutures.size();
        this.totalIndexes = arrayList.size();
        HashMap<PartitionKey, ValidateIndexesPartitionResult> partResults = new HashMap<PartitionKey, ValidateIndexesPartitionResult>();
        HashMap<String, ValidateIndexesPartitionResult> hashMap = new HashMap<String, ValidateIndexesPartitionResult>();
        int curIdx = 0;
        try {
            Future fut;
            for (int curPart = 0; curPart < procPartFutures.size(); ++curPart) {
                fut = (Future)procPartFutures.get(curPart);
                Map partRes = (Map)fut.get();
                partResults.putAll(partRes);
            }
            while (curIdx < arrayList.size()) {
                fut = (Future)arrayList.get(curIdx);
                Map idxRes = (Map)fut.get();
                hashMap.putAll(idxRes);
                ++curIdx;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            int j;
            for (j = curPart; j < procPartFutures.size(); ++j) {
                ((Future)procPartFutures.get(j)).cancel(false);
            }
            for (j = curIdx; j < arrayList.size(); ++j) {
                ((Future)arrayList.get(j)).cancel(false);
            }
            if (e instanceof InterruptedException) {
                throw new IgniteInterruptedException((InterruptedException)e);
            }
            if (e.getCause() instanceof IgniteException) {
                throw (IgniteException)e.getCause();
            }
            throw new IgniteException(e.getCause());
        }
        return new VisorValidateIndexesJobResult(partResults, hashMap);
    }

    private Future<Map<PartitionKey, ValidateIndexesPartitionResult>> processPartitionAsync(final CacheGroupContext grpCtx, final GridDhtLocalPartition part) {
        return this.calcExecutor.submit(new Callable<Map<PartitionKey, ValidateIndexesPartitionResult>>(){

            @Override
            public Map<PartitionKey, ValidateIndexesPartitionResult> call() throws Exception {
                return ValidateIndexesClosure.this.processPartition(grpCtx, part);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<PartitionKey, ValidateIndexesPartitionResult> processPartition(CacheGroupContext grpCtx, GridDhtLocalPartition part) {
        ValidateIndexesPartitionResult partRes;
        if (!part.reserve()) {
            return Collections.emptyMap();
        }
        try {
            Method m;
            if (part.state() != GridDhtPartitionState.OWNING) {
                Map<PartitionKey, ValidateIndexesPartitionResult> map2 = Collections.emptyMap();
                return map2;
            }
            long updateCntrBefore = part.updateCounter();
            long partSize = part.dataStore().fullSize();
            GridIterator<CacheDataRow> it = grpCtx.offheap().partitionIterator(part.id());
            Object consId = this.ignite.context().discovery().localNode().consistentId();
            boolean isPrimary = part.primary(grpCtx.topology().readyTopologyVersion());
            partRes = new ValidateIndexesPartitionResult(updateCntrBefore, partSize, isPrimary, consId, null);
            boolean enoughIssues = false;
            GridQueryProcessor qryProcessor = this.ignite.context().query();
            try {
                m = GridQueryProcessor.class.getDeclaredMethod("typeByValue", String.class, CacheObjectContext.class, KeyCacheObject.class, CacheObject.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.log.error("Failed to invoke typeByValue", e);
                throw new IgniteException(e);
            }
            m.setAccessible(true);
            boolean skipConditions = this.checkFirst > 0 || this.checkThrough > 0;
            boolean bothSkipConditions = this.checkFirst > 0 && this.checkThrough > 0;
            long current = 0L;
            long processedNumber = 0L;
            while (it.hasNextX() && !enoughIssues) {
                GridCacheContext cacheCtx;
                CacheDataRow row = it.nextX();
                if (skipConditions) {
                    if (bothSkipConditions) {
                        if (processedNumber > (long)this.checkFirst) break;
                        if (current++ % (long)this.checkThrough > 0L) continue;
                        ++processedNumber;
                    } else if (this.checkFirst > 0) {
                        if (current++ > (long)this.checkFirst) {
                            break;
                        }
                    } else if (current++ % (long)this.checkThrough > 0L) continue;
                }
                int cacheId = row.cacheId() == 0 ? grpCtx.groupId() : row.cacheId();
                GridCacheContext gridCacheContext = cacheCtx = row.cacheId() == 0 ? grpCtx.singleCacheContext() : grpCtx.shared().cacheContext(row.cacheId());
                if (cacheCtx == null) {
                    throw new IgniteException("Unknown cacheId of CacheDataRow: " + cacheId);
                }
                try {
                    IgniteH2Indexing indexing;
                    GridH2Table gridH2Tbl;
                    QueryTypeDescriptorImpl res = (QueryTypeDescriptorImpl)m.invoke((Object)qryProcessor, cacheCtx.name(), cacheCtx.cacheObjectContext(), row.key(), row.value(), true);
                    if (res == null || (gridH2Tbl = (indexing = (IgniteH2Indexing)qryProcessor.getIndexing()).dataTable(cacheCtx.name(), res.tableName())) == null) continue;
                    GridH2RowDescriptor gridH2RowDesc = gridH2Tbl.rowDescriptor();
                    GridH2Row h2Row = gridH2RowDesc.createRow(row);
                    ArrayList<Index> indexes = gridH2Tbl.getIndexes();
                    for (Index idx : indexes) {
                        try {
                            Cursor cursor = idx.find((Session)null, (SearchRow)h2Row, (SearchRow)h2Row);
                            if (cursor == null) throw new IgniteCheckedException("Key is present in CacheDataTree, but can't be found in SQL index.");
                            if (cursor.next()) continue;
                            throw new IgniteCheckedException("Key is present in CacheDataTree, but can't be found in SQL index.");
                        }
                        catch (Throwable t) {
                            Object o = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)grpCtx.cacheObjectContext(), row.key(), true, true);
                            IndexValidationIssue is = new IndexValidationIssue(o.toString(), cacheCtx.name(), idx.getName(), t);
                            this.log.error("Failed to lookup key: " + is.toString());
                            enoughIssues |= partRes.reportIssue(is);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    this.log.error("Failed to invoke typeByValue", e);
                    throw new IgniteException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    this.log.error("Failed to invoke typeByValue", target);
                    throw new IgniteException(target);
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to process partition [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "]", e);
            Map<PartitionKey, ValidateIndexesPartitionResult> map3 = Collections.emptyMap();
            return map3;
        }
        finally {
            part.release();
            this.printProgressIfNeeded();
        }
        PartitionKey partKey = new PartitionKey(grpCtx.groupId(), part.id(), grpCtx.cacheOrGroupName());
        this.processedPartitions.incrementAndGet();
        return Collections.singletonMap(partKey, partRes);
    }

    private void printProgressIfNeeded() {
        long lastTs;
        long curTs = U.currentTimeMillis();
        if (curTs - (lastTs = this.lastProgressPrintTs.get()) >= 60000L && this.lastProgressPrintTs.compareAndSet(lastTs, curTs)) {
            this.log.warning("Current progress of ValidateIndexesClosure: processed " + this.processedPartitions.get() + " of " + this.totalPartitions + " partitions, " + this.processedIndexes.get() + " of " + this.totalIndexes + " SQL indexes");
        }
    }

    private Future<Map<String, ValidateIndexesPartitionResult>> processIndexAsync(final GridCacheContext ctx, final Index idx) {
        return this.calcExecutor.submit(new Callable<Map<String, ValidateIndexesPartitionResult>>(){

            @Override
            public Map<String, ValidateIndexesPartitionResult> call() throws Exception {
                return ValidateIndexesClosure.this.processIndex(ctx, idx);
            }
        });
    }

    private Map<String, ValidateIndexesPartitionResult> processIndex(GridCacheContext ctx, Index idx) {
        Object consId = this.ignite.context().discovery().localNode().consistentId();
        ValidateIndexesPartitionResult idxValidationRes = new ValidateIndexesPartitionResult(-1L, -1L, true, consId, idx.getName());
        boolean enoughIssues = false;
        Cursor cursor = null;
        try {
            cursor = idx.find((Session)null, null, null);
            if (cursor == null) {
                throw new IgniteCheckedException("Can't iterate through index: " + idx);
            }
        }
        catch (Throwable t) {
            IndexValidationIssue is = new IndexValidationIssue(null, ctx.name(), idx.getName(), t);
            this.log.error("Find in index failed: " + is.toString());
            enoughIssues = true;
        }
        boolean skipConditions = this.checkFirst > 0 || this.checkThrough > 0;
        boolean bothSkipConditions = this.checkFirst > 0 && this.checkThrough > 0;
        long current = 0L;
        long processedNumber = 0L;
        KeyCacheObject previousKey = null;
        while (!enoughIssues) {
            KeyCacheObject h2key = null;
            try {
                try {
                    if (!cursor.next()) {
                        break;
                    }
                }
                catch (IllegalStateException e) {
                    throw new IgniteCheckedException("Key is present in SQL index, but is missing in corresponding data page. Previous successfully read key: " + CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)ctx.cacheObjectContext(), previousKey, true, true), e);
                }
                GridH2Row h2Row = (GridH2Row)cursor.get();
                if (skipConditions) {
                    if (bothSkipConditions) {
                        if (processedNumber > (long)this.checkFirst) break;
                        if (current++ % (long)this.checkThrough > 0L) continue;
                        ++processedNumber;
                    } else if (this.checkFirst > 0) {
                        if (current++ > (long)this.checkFirst) {
                            break;
                        }
                    } else if (current++ % (long)this.checkThrough > 0L) continue;
                }
                h2key = h2Row.key();
                CacheDataRow cacheDataStoreRow = ctx.group().offheap().read(ctx, h2key);
                if (cacheDataStoreRow == null) {
                    throw new IgniteCheckedException("Key is present in SQL index, but can't be found in CacheDataTree.");
                }
                previousKey = h2key;
            }
            catch (Throwable t) {
                Object o = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)ctx.cacheObjectContext(), h2key, true, true);
                IndexValidationIssue is = new IndexValidationIssue(String.valueOf(o), ctx.name(), idx.getName(), t);
                this.log.error("Failed to lookup key: " + is.toString());
                enoughIssues |= idxValidationRes.reportIssue(is);
            }
        }
        String uniqueIdxName = "[cache=" + ctx.name() + ", idx=" + idx.getName() + "]";
        this.processedIndexes.incrementAndGet();
        this.printProgressIfNeeded();
        return Collections.singletonMap(uniqueIdxName, idxValidationRes);
    }
}

