/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorQueryIndexField
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private boolean sort;

    public VisorQueryIndexField() {
    }

    public VisorQueryIndexField(String name, boolean sort2) {
        this.name = name;
        this.sort = sort2;
    }

    public static List<VisorQueryIndexField> list(QueryIndex idx) {
        ArrayList<VisorQueryIndexField> res = new ArrayList<VisorQueryIndexField>();
        for (Map.Entry<String, Boolean> field2 : idx.getFields().entrySet()) {
            res.add(new VisorQueryIndexField(field2.getKey(), field2.getValue() == false));
        }
        return res;
    }

    public String getName() {
        return this.name;
    }

    public boolean getSortOrder() {
        return this.sort;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeBoolean(this.sort);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.sort = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorQueryIndexField.class, this);
    }
}

