/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.query.VisorQueryCleanupTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryCursor;
import org.apache.ignite.internal.visor.util.VisorClusterGroupEmptyException;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorQueryCleanupTask
extends VisorMultiNodeTask<VisorQueryCleanupTaskArg, Void, Void> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorQueryCleanupTaskArg, Void> job(VisorQueryCleanupTaskArg arg) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<? extends ComputeJob, ClusterNode> map0(List<ClusterNode> subgrid, @Nullable VisorTaskArgument<VisorQueryCleanupTaskArg> arg) {
        Set<UUID> nodeIds = ((VisorQueryCleanupTaskArg)this.taskArg).getQueryIds().keySet();
        if (nodeIds.isEmpty()) {
            throw new VisorClusterGroupEmptyException("Nothing to clear. List with node IDs is empty!");
        }
        HashMap<VisorQueryCleanupJob, ClusterNode> map2 = U.newHashMap(nodeIds.size());
        try {
            for (ClusterNode node : subgrid) {
                if (!nodeIds.contains(node.id())) continue;
                map2.put(new VisorQueryCleanupJob(((VisorQueryCleanupTaskArg)this.taskArg).getQueryIds().get(node.id()), this.debug), node);
            }
            if (map2.isEmpty()) {
                StringBuilder notFoundNodes = new StringBuilder();
                for (UUID nid : nodeIds) {
                    notFoundNodes.append(notFoundNodes.length() == 0 ? "" : ",").append(U.id8(nid));
                }
                throw new VisorClusterGroupEmptyException("Failed to clear query results. Nodes are not available: [" + notFoundNodes + "]");
            }
            HashMap<VisorQueryCleanupJob, ClusterNode> hashMap = map2;
            return hashMap;
        }
        finally {
            if (this.debug) {
                VisorTaskUtils.logMapped(this.ignite.log(), this.getClass(), map2.values());
            }
        }
    }

    @Override
    @Nullable
    protected Void reduce0(List list2) {
        return null;
    }

    private static class VisorQueryCleanupJob
    extends VisorJob<Collection<String>, Void> {
        private static final long serialVersionUID = 0L;

        protected VisorQueryCleanupJob(Collection<String> arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Void run(Collection<String> qryIds) {
            ConcurrentMap storage = this.ignite.cluster().nodeLocalMap();
            for (String qryId : qryIds) {
                VisorQueryCursor cur = (VisorQueryCursor)storage.remove(qryId);
                if (cur == null) continue;
                cur.close();
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorQueryCleanupJob.class, this);
        }
    }
}

