/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.node.VisorSpiDescription;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiConfiguration;

public class VisorSpisConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private VisorSpiDescription discoSpi;
    private VisorSpiDescription commSpi;
    private VisorSpiDescription evtSpi;
    private VisorSpiDescription colSpi;
    private VisorSpiDescription deploySpi;
    private VisorSpiDescription[] cpSpis;
    private VisorSpiDescription[] failSpis;
    private VisorSpiDescription[] loadBalancingSpis;
    private VisorSpiDescription[] indexingSpis;

    public VisorSpisConfiguration() {
    }

    private static VisorSpiDescription collectSpiInfo(IgniteSpi spi) {
        Class<?> spiCls = spi.getClass();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("Class Name", VisorTaskUtils.compactClass(spi));
        block5: for (Method mtd : spiCls.getDeclaredMethods()) {
            String mtdName;
            if (!mtd.isAnnotationPresent(IgniteSpiConfiguration.class) || mtd.isAnnotationPresent(Deprecated.class) || !(mtdName = mtd.getName()).startsWith("set")) continue;
            String propName = Character.toLowerCase(mtdName.charAt(3)) + mtdName.substring(4);
            try {
                String[] getterNames;
                for (String getterName : getterNames = new String[]{"get" + mtdName.substring(3), "is" + mtdName.substring(3), "get" + mtdName.substring(3) + "Formatted"}) {
                    try {
                        Method getter2 = spiCls.getDeclaredMethod(getterName, new Class[0]);
                        Object getRes = getter2.invoke((Object)spi, new Object[0]);
                        res.put(propName, VisorTaskUtils.compactObject(getRes));
                        continue block5;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (IllegalAccessException ignored) {
                res.put(propName, "Error: Method Cannot Be Accessed");
            }
            catch (InvocationTargetException ite) {
                res.put(propName, "Error: Method Threw An Exception: " + ite);
            }
        }
        return new VisorSpiDescription(spi.getName(), res);
    }

    private static VisorSpiDescription[] collectSpiInfo(IgniteSpi[] spis) {
        VisorSpiDescription[] res = new VisorSpiDescription[spis.length];
        for (int i = 0; i < spis.length; ++i) {
            res[i] = VisorSpisConfiguration.collectSpiInfo(spis[i]);
        }
        return res;
    }

    public VisorSpisConfiguration(IgniteConfiguration c) {
        this.discoSpi = VisorSpisConfiguration.collectSpiInfo(c.getDiscoverySpi());
        this.commSpi = VisorSpisConfiguration.collectSpiInfo(c.getCommunicationSpi());
        this.evtSpi = VisorSpisConfiguration.collectSpiInfo(c.getEventStorageSpi());
        this.colSpi = VisorSpisConfiguration.collectSpiInfo(c.getCollisionSpi());
        this.deploySpi = VisorSpisConfiguration.collectSpiInfo(c.getDeploymentSpi());
        this.cpSpis = VisorSpisConfiguration.collectSpiInfo(c.getCheckpointSpi());
        this.failSpis = VisorSpisConfiguration.collectSpiInfo(c.getFailoverSpi());
        this.loadBalancingSpis = VisorSpisConfiguration.collectSpiInfo(c.getLoadBalancingSpi());
        this.indexingSpis = F.asArray(VisorSpisConfiguration.collectSpiInfo(c.getIndexingSpi()));
    }

    public VisorSpiDescription getDiscoverySpi() {
        return this.discoSpi;
    }

    public VisorSpiDescription getCommunicationSpi() {
        return this.commSpi;
    }

    public VisorSpiDescription getEventStorageSpi() {
        return this.evtSpi;
    }

    public VisorSpiDescription getCollisionSpi() {
        return this.colSpi;
    }

    public VisorSpiDescription getDeploymentSpi() {
        return this.deploySpi;
    }

    public VisorSpiDescription[] getCheckpointSpis() {
        return this.cpSpis;
    }

    public VisorSpiDescription[] getFailoverSpis() {
        return this.failSpis;
    }

    public VisorSpiDescription[] getLoadBalancingSpis() {
        return this.loadBalancingSpis;
    }

    public VisorSpiDescription[] getIndexingSpis() {
        return this.indexingSpis;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.discoSpi);
        out.writeObject(this.commSpi);
        out.writeObject(this.evtSpi);
        out.writeObject(this.colSpi);
        out.writeObject(this.deploySpi);
        out.writeObject(this.cpSpis);
        out.writeObject(this.failSpis);
        out.writeObject(this.loadBalancingSpis);
        out.writeObject(this.indexingSpis);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.discoSpi = (VisorSpiDescription)in.readObject();
        this.commSpi = (VisorSpiDescription)in.readObject();
        this.evtSpi = (VisorSpiDescription)in.readObject();
        this.colSpi = (VisorSpiDescription)in.readObject();
        this.deploySpi = (VisorSpiDescription)in.readObject();
        this.cpSpis = (VisorSpiDescription[])in.readObject();
        this.failSpis = (VisorSpiDescription[])in.readObject();
        this.loadBalancingSpis = (VisorSpiDescription[])in.readObject();
        this.indexingSpis = (VisorSpiDescription[])in.readObject();
    }

    public String toString() {
        return S.toString(VisorSpisConfiguration.class, this);
    }
}

