/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.igfs.VisorIgfsProfiler;
import org.apache.ignite.internal.visor.igfs.VisorIgfsProfilerEntry;
import org.apache.ignite.internal.visor.igfs.VisorIgfsProfilerTaskArg;
import org.apache.ignite.internal.visor.igfs.VisorIgfsProfilerUniformityCounters;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

@GridInternal
public class VisorIgfsProfilerTask
extends VisorOneNodeTask<VisorIgfsProfilerTaskArg, List<VisorIgfsProfilerEntry>> {
    private static final long serialVersionUID = 0L;
    private static final Comparator<VisorIgfsProfilerParsedLine> PARSED_LINE_BY_TS_COMPARATOR = new Comparator<VisorIgfsProfilerParsedLine>(){

        @Override
        public int compare(VisorIgfsProfilerParsedLine a, VisorIgfsProfilerParsedLine b) {
            return a.ts < b.ts ? -1 : (a.ts > b.ts ? 1 : 0);
        }
    };

    protected VisorIgfsProfilerJob job(VisorIgfsProfilerTaskArg arg) {
        return new VisorIgfsProfilerJob(arg, this.debug);
    }

    private static class VisorIgfsProfilerJob
    extends VisorJob<VisorIgfsProfilerTaskArg, List<VisorIgfsProfilerEntry>> {
        private static final long serialVersionUID = 0L;
        private static final int LOG_COL_TIMESTAMP = 0;
        private static final int LOG_COL_THREAD_ID = 1;
        private static final int LOG_COL_ENTRY_TYPE = 3;
        private static final int LOG_COL_PATH = 4;
        private static final int LOG_COL_IGFS_MODE = 5;
        private static final int LOG_COL_STREAM_ID = 6;
        private static final int LOG_COL_DATA_LEN = 8;
        private static final int LOG_COL_OVERWRITE = 10;
        private static final int LOG_COL_POS = 13;
        private static final int LOG_COL_USER_TIME = 17;
        private static final int LOG_COL_SYSTEM_TIME = 18;
        private static final int LOG_COL_TOTAL_BYTES = 19;
        private static final Set<Integer> LOG_TYPES = new HashSet<Integer>();

        private VisorIgfsProfilerJob(VisorIgfsProfilerTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected List<VisorIgfsProfilerEntry> run(VisorIgfsProfilerTaskArg arg) {
            String name = arg.getIgfsName();
            try {
                Path logsDir = VisorTaskUtils.resolveIgfsProfilerLogsDir(this.ignite.fileSystem(name));
                if (logsDir != null) {
                    return this.parse(logsDir, name);
                }
                return Collections.emptyList();
            }
            catch (IOException | IllegalArgumentException e) {
                throw new IgniteException("Failed to parse profiler logs for IGFS: " + name, e);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        private boolean parseBoolean(String[] ss, int ix) {
            return ix < ss.length && "1".equals(ss[ix]);
        }

        private int parseInt(String[] ss, int ix, int dflt) {
            if (ss.length <= ix) {
                return dflt;
            }
            String s2 = ss[ix];
            return s2.isEmpty() ? dflt : Integer.parseInt(s2);
        }

        private long parseLong(String[] ss, int ix, long dflt) {
            if (ss.length <= ix) {
                return dflt;
            }
            String s2 = ss[ix];
            return s2.isEmpty() ? dflt : Long.parseLong(s2);
        }

        private String parseString(String[] ss, int ix) {
            if (ss.length <= ix) {
                return "";
            }
            String s2 = ss[ix];
            return s2.isEmpty() ? "" : s2;
        }

        private IgfsMode parseIgfsMode(String[] ss, int ix) {
            if (ss.length <= ix) {
                return null;
            }
            String s2 = ss[ix];
            return s2.isEmpty() ? null : IgfsMode.valueOf(s2);
        }

        private VisorIgfsProfilerParsedLine parseLine(String s2) {
            int entryType;
            String[] ss = s2.split(";");
            long streamId = this.parseLong(ss, 6, -1L);
            if (streamId >= 0L && LOG_TYPES.contains(entryType = this.parseInt(ss, 3, -1))) {
                return new VisorIgfsProfilerParsedLine(this.parseLong(ss, 0, 0L), entryType, this.parseString(ss, 4), this.parseIgfsMode(ss, 5), streamId, this.parseLong(ss, 8, 0L), this.parseBoolean(ss, 10), this.parseLong(ss, 13, 0L), this.parseLong(ss, 17, 0L), this.parseLong(ss, 18, 0L), this.parseLong(ss, 19, 0L));
            }
            return null;
        }

        private VisorIgfsProfilerEntry aggregateParsedLines(List<VisorIgfsProfilerParsedLine> lines2) {
            VisorIgfsProfilerUniformityCounters counters = new VisorIgfsProfilerUniformityCounters();
            Collections.sort(lines2, PARSED_LINE_BY_TS_COMPARATOR);
            String path2 = "";
            long ts = 0L;
            long size2 = 0L;
            long bytesRead = 0L;
            long readTime = 0L;
            long userReadTime = 0L;
            long bytesWritten = 0L;
            long writeTime = 0L;
            long userWriteTime = 0L;
            IgfsMode mode = null;
            block7: for (VisorIgfsProfilerParsedLine line : lines2) {
                if (!line.path.isEmpty()) {
                    path2 = line.path;
                }
                ts = line.ts;
                if (line.mode != null) {
                    mode = line.mode;
                }
                switch (line.entryType) {
                    case 0: {
                        size2 = line.dataLen;
                        counters.invalidate(size2);
                        continue block7;
                    }
                    case 1: {
                        if (!line.overwrite) continue block7;
                        size2 = 0L;
                        counters.invalidate(size2);
                        continue block7;
                    }
                    case 7: {
                        bytesRead += line.totalBytes;
                        readTime += line.sysTime;
                        userReadTime += line.userTime;
                        counters.increment(line.pos, line.totalBytes);
                        continue block7;
                    }
                    case 8: {
                        bytesWritten += line.totalBytes;
                        writeTime += line.sysTime;
                        userWriteTime += line.userTime;
                        counters.invalidate(size2 += line.totalBytes);
                        continue block7;
                    }
                    case 2: {
                        counters.increment(line.pos, line.totalBytes);
                        continue block7;
                    }
                }
                throw new IllegalStateException("Unexpected IGFS profiler log entry type: " + line.entryType);
            }
            return path2.isEmpty() ? null : new VisorIgfsProfilerEntry(path2, ts, mode, size2, bytesRead, readTime, userReadTime, bytesWritten, writeTime, userWriteTime, counters);
        }

        /*
         * WARNING - void declaration
         */
        private List<VisorIgfsProfilerEntry> parseFile(Path p) throws IOException {
            ArrayList<VisorIgfsProfilerParsedLine> parsedLines;
            block23: {
                parsedLines = new ArrayList<VisorIgfsProfilerParsedLine>(512);
                BufferedReader br = Files.newBufferedReader(p, Charset.forName("UTF-8"));
                Object object = null;
                try {
                    void var5_7;
                    String string2 = br.readLine();
                    if (string2 == null) break block23;
                    if ("Timestamp;ThreadID;PID;Type;Path;Mode;StreamId;BufSize;DataLen;Append;Overwrite;Replication;BlockSize;Position;ReadLen;SkipCnt;ReadLimit;UserTime;SystemTime;TotalBytes;DestPath;Recursive;List".equalsIgnoreCase(string2)) {
                        String string3 = br.readLine();
                    }
                    while (var5_7 != null) {
                        try {
                            VisorIgfsProfilerParsedLine ln = this.parseLine((String)var5_7);
                            if (ln != null) {
                                parsedLines.add(ln);
                            }
                        }
                        catch (NumberFormatException ln) {
                            // empty catch block
                        }
                        String string4 = br.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br != null) {
                        if (object != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            HashMap<Long, ArrayList<VisorIgfsProfilerParsedLine>> byStreamId = new HashMap<Long, ArrayList<VisorIgfsProfilerParsedLine>>();
            for (VisorIgfsProfilerParsedLine visorIgfsProfilerParsedLine : parsedLines) {
                ArrayList<VisorIgfsProfilerParsedLine> grp = (ArrayList<VisorIgfsProfilerParsedLine>)byStreamId.get(visorIgfsProfilerParsedLine.streamId);
                if (grp == null) {
                    grp = new ArrayList<VisorIgfsProfilerParsedLine>();
                    byStreamId.put(visorIgfsProfilerParsedLine.streamId, grp);
                }
                grp.add(visorIgfsProfilerParsedLine);
            }
            ArrayList<VisorIgfsProfilerEntry> entries = new ArrayList<VisorIgfsProfilerEntry>(byStreamId.size());
            for (Object lines2 : byStreamId.values()) {
                VisorIgfsProfilerEntry entry2 = this.aggregateParsedLines((List<VisorIgfsProfilerParsedLine>)lines2);
                if (entry2 == null) continue;
                entries.add(entry2);
            }
            HashMap<String, ArrayList<VisorIgfsProfilerEntry>> hashMap = new HashMap<String, ArrayList<VisorIgfsProfilerEntry>>();
            for (VisorIgfsProfilerEntry entry2 : entries) {
                ArrayList<VisorIgfsProfilerEntry> grp = (ArrayList<VisorIgfsProfilerEntry>)hashMap.get(entry2.getPath());
                if (grp == null) {
                    grp = new ArrayList<VisorIgfsProfilerEntry>();
                    hashMap.put(entry2.getPath(), grp);
                }
                grp.add(entry2);
            }
            ArrayList<VisorIgfsProfilerEntry> res = new ArrayList<VisorIgfsProfilerEntry>(hashMap.size());
            for (List lst : hashMap.values()) {
                res.add(VisorIgfsProfiler.aggregateIgfsProfilerEntries(lst));
            }
            return res;
        }

        private List<VisorIgfsProfilerEntry> parse(Path logDir, String igfsName) throws IOException {
            ArrayList<VisorIgfsProfilerEntry> parsedFiles = new ArrayList<VisorIgfsProfilerEntry>(512);
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(logDir);){
                PathMatcher matcher2 = FileSystems.getDefault().getPathMatcher("glob:igfs-log-" + igfsName + "-*.csv");
                for (Path p : dirStream) {
                    if (!matcher2.matches(p.getFileName())) continue;
                    try {
                        parsedFiles.addAll(this.parseFile(p));
                    }
                    catch (NoSuchFileException noSuchFileException) {
                    }
                    catch (Exception e) {
                        this.ignite.log().warning("Failed to parse IGFS profiler log file: " + p, e);
                    }
                }
            }
            return parsedFiles;
        }

        public String toString() {
            return S.toString(VisorIgfsProfilerJob.class, this);
        }

        static {
            LOG_TYPES.add(0);
            LOG_TYPES.add(1);
            LOG_TYPES.add(2);
            LOG_TYPES.add(7);
            LOG_TYPES.add(8);
        }
    }

    private static class VisorIgfsProfilerParsedLine {
        private final long ts;
        private final int entryType;
        private final String path;
        private final IgfsMode mode;
        private final long streamId;
        private final long dataLen;
        private final boolean overwrite;
        private final long pos;
        private final long userTime;
        private final long sysTime;
        private final long totalBytes;

        private VisorIgfsProfilerParsedLine(long ts, int entryType, String path2, IgfsMode mode, long streamId, long dataLen, boolean overwrite, long pos, long userTime, long sysTime, long totalBytes) {
            this.ts = ts;
            this.entryType = entryType;
            this.path = path2;
            this.mode = mode;
            this.streamId = streamId;
            this.dataLen = dataLen;
            this.overwrite = overwrite;
            this.pos = pos;
            this.userTime = userTime;
            this.sysTime = sysTime;
            this.totalBytes = totalBytes;
        }
    }
}

