/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.igfs.VisorIgfsProfilerUniformityCounters;

public class VisorIgfsProfilerEntry
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final Comparator<VisorIgfsProfilerEntry> ENTRY_TIMESTAMP_COMPARATOR = new Comparator<VisorIgfsProfilerEntry>(){

        @Override
        public int compare(VisorIgfsProfilerEntry a, VisorIgfsProfilerEntry b) {
            return Long.compare(a.ts, b.ts);
        }
    };
    private String path;
    private long ts;
    private IgfsMode mode;
    private long size;
    private long bytesRead;
    private long readTime;
    private long userReadTime;
    private long bytesWritten;
    private long writeTime;
    private long userWriteTime;
    private double uniformity = -1.0;
    private VisorIgfsProfilerUniformityCounters counters;
    private long readSpeed;
    private long writeSpeed;

    public VisorIgfsProfilerEntry() {
    }

    public VisorIgfsProfilerEntry(String path2, long ts, IgfsMode mode, long size2, long bytesRead, long readTime, long userReadTime, long bytesWritten, long writeTime, long userWriteTime, VisorIgfsProfilerUniformityCounters counters) {
        assert (counters != null);
        this.path = path2;
        this.ts = ts;
        this.mode = mode;
        this.size = size2;
        this.bytesRead = bytesRead;
        this.readTime = readTime;
        this.userReadTime = userReadTime;
        this.bytesWritten = bytesWritten;
        this.writeTime = writeTime;
        this.userWriteTime = userWriteTime;
        this.counters = counters;
        this.readSpeed = VisorIgfsProfilerEntry.speed(bytesRead, readTime);
        this.writeSpeed = VisorIgfsProfilerEntry.speed(bytesWritten, writeTime);
    }

    private static long speed(long bytes2, long time) {
        if (time > 0L) {
            double bytesScaled = (double)bytes2 * 100000.0;
            double timeScaled = (double)time / 10000.0;
            return (long)(bytesScaled / timeScaled);
        }
        return -1L;
    }

    public String getPath() {
        return this.path;
    }

    public long getTimestamp() {
        return this.ts;
    }

    public IgfsMode getMode() {
        return this.mode;
    }

    public long getSize() {
        return this.size;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public long getUserReadTime() {
        return this.userReadTime;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public long getUserWriteTime() {
        return this.userWriteTime;
    }

    public double getUniformity() {
        if (this.uniformity < 0.0) {
            this.uniformity = this.counters.calc();
        }
        return this.uniformity;
    }

    public VisorIgfsProfilerUniformityCounters getCounters() {
        return this.counters;
    }

    public long getReadSpeed() {
        return this.readSpeed;
    }

    public long getWriteSpeed() {
        return this.writeSpeed;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.path);
        out.writeLong(this.ts);
        U.writeEnum(out, this.mode);
        out.writeLong(this.size);
        out.writeLong(this.bytesRead);
        out.writeLong(this.readTime);
        out.writeLong(this.userReadTime);
        out.writeLong(this.bytesWritten);
        out.writeLong(this.writeTime);
        out.writeLong(this.userWriteTime);
        out.writeDouble(this.uniformity);
        out.writeObject(this.counters);
        out.writeLong(this.readSpeed);
        out.writeLong(this.writeSpeed);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = U.readString(in);
        this.ts = in.readLong();
        this.mode = IgfsMode.fromOrdinal(in.readByte());
        this.size = in.readLong();
        this.bytesRead = in.readLong();
        this.readTime = in.readLong();
        this.userReadTime = in.readLong();
        this.bytesWritten = in.readLong();
        this.writeTime = in.readLong();
        this.userWriteTime = in.readLong();
        this.uniformity = in.readDouble();
        this.counters = (VisorIgfsProfilerUniformityCounters)in.readObject();
        this.readSpeed = in.readLong();
        this.writeSpeed = in.readLong();
    }

    public String toString() {
        return S.toString(VisorIgfsProfilerEntry.class, this);
    }
}

