/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.igfs.VisorIgfsProfilerEntry;
import org.apache.ignite.internal.visor.igfs.VisorIgfsProfilerUniformityCounters;

public class VisorIgfsProfiler {
    public static final int UNIFORMITY_DFLT_BLOCK_SIZE = 4096;
    public static final int UNIFORMITY_BLOCKS = 100;

    public static VisorIgfsProfilerEntry aggregateIgfsProfilerEntries(List<VisorIgfsProfilerEntry> entries) {
        assert (!F.isEmpty(entries));
        if (entries.size() == 1) {
            return entries.get(0);
        }
        String path2 = entries.get(0).getPath();
        Collections.sort(entries, VisorIgfsProfilerEntry.ENTRY_TIMESTAMP_COMPARATOR);
        long ts = 0L;
        long size2 = 0L;
        long bytesRead = 0L;
        long readTime = 0L;
        long userReadTime = 0L;
        long bytesWritten = 0L;
        long writeTime = 0L;
        long userWriteTime = 0L;
        IgfsMode mode = null;
        VisorIgfsProfilerUniformityCounters counters = new VisorIgfsProfilerUniformityCounters();
        for (VisorIgfsProfilerEntry entry2 : entries) {
            ts = entry2.getTimestamp();
            size2 = entry2.getSize();
            mode = entry2.getMode();
            bytesRead += entry2.getBytesRead();
            readTime += entry2.getReadTime();
            userReadTime += entry2.getUserReadTime();
            bytesWritten += entry2.getBytesWritten();
            writeTime += entry2.getWriteTime();
            userWriteTime += entry2.getUserWriteTime();
            counters.aggregate(entry2.getCounters());
        }
        return new VisorIgfsProfilerEntry(path2, ts, mode, size2, bytesRead, readTime, userReadTime, bytesWritten, writeTime, userWriteTime, counters);
    }
}

