/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.file.VisorLatestTextFilesTaskArg;
import org.apache.ignite.internal.visor.log.VisorLogFile;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorLatestTextFilesTask
extends VisorOneNodeTask<VisorLatestTextFilesTaskArg, Collection<VisorLogFile>> {
    private static final long serialVersionUID = 0L;

    protected VisorLatestTextFilesJob job(VisorLatestTextFilesTaskArg arg) {
        return new VisorLatestTextFilesJob(arg, this.debug);
    }

    private static class VisorLatestTextFilesJob
    extends VisorJob<VisorLatestTextFilesTaskArg, Collection<VisorLogFile>> {
        private static final long serialVersionUID = 0L;

        private VisorLatestTextFilesJob(VisorLatestTextFilesTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        @Nullable
        protected Collection<VisorLogFile> run(VisorLatestTextFilesTaskArg arg) {
            String path2 = arg.getPath();
            String regexp = arg.getRegexp();
            assert (path2 != null);
            assert (regexp != null);
            try {
                File folder = VisorTaskUtils.resolveIgnitePath(path2);
                if (folder == null) {
                    return null;
                }
                List<VisorLogFile> files2 = VisorTaskUtils.matchedFiles(folder, regexp);
                if (files2.isEmpty()) {
                    return null;
                }
                if (files2.size() > 5000) {
                    files2 = new ArrayList<VisorLogFile>(files2.subList(0, 5000));
                }
                return files2;
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public String toString() {
            return S.toString(VisorLatestTextFilesJob.class, this);
        }
    }
}

