/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.compute;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorCoordinatorNodeTask;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorGatewayTask
implements ComputeTask<Object[], Object> {
    private static final long serialVersionUID = 0L;
    private static final int JOB_ARG_IDX = 3;
    private static final Map<Class, Integer> TYPE_ARG_LENGTH = new HashMap<Class, Integer>(4);
    @IgniteInstanceResource
    protected transient IgniteEx ignite;

    @Override
    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object[] args2) throws IgniteException {
        assert (args2 != null);
        assert (args2.length >= 2);
        return Collections.singletonMap(new VisorGatewayJob(args2), this.ignite.localNode());
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        return ComputeJobResultPolicy.WAIT;
    }

    @Override
    @Nullable
    public Object reduce(List<ComputeJobResult> results) throws IgniteException {
        assert (results.size() == 1);
        ComputeJobResult res = F.first(results);
        assert (res != null);
        IgniteException ex = res.getException();
        if (ex != null) {
            throw ex;
        }
        return res.getData();
    }

    static {
        TYPE_ARG_LENGTH.put(Collection.class, 2);
        TYPE_ARG_LENGTH.put(Set.class, 2);
        TYPE_ARG_LENGTH.put(List.class, 2);
        TYPE_ARG_LENGTH.put(Map.class, 3);
        TYPE_ARG_LENGTH.put(IgniteBiTuple.class, 4);
        TYPE_ARG_LENGTH.put(GridTuple3.class, 6);
    }

    private static class VisorGatewayJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        private static final byte[] ZERO_BYTES = new byte[0];
        @IgniteInstanceResource
        protected transient IgniteEx ignite;
        @JobContextResource
        protected transient ComputeJobContext jobCtx;
        private final int argsCnt;
        private transient IgniteFuture fut;

        VisorGatewayJob(@Nullable Object[] args2) {
            super(args2);
            assert (args2 != null);
            this.argsCnt = args2.length;
        }

        @Nullable
        private Object toJobArgument(Class cls, int startIdx) throws ClassNotFoundException {
            boolean isList;
            String arg = (String)this.argument(startIdx);
            boolean bl = isList = cls == Collection.class || cls == List.class;
            if (isList || cls == Set.class) {
                String items = (String)this.argument(startIdx + 1);
                if (items == null || "null".equals(items)) {
                    return null;
                }
                Class<?> itemsCls = Class.forName(arg);
                AbstractCollection res = isList ? new ArrayList() : new HashSet();
                for (String item : items.split(";")) {
                    res.add(this.toObject(itemsCls, item));
                }
                return res;
            }
            if (cls == IgniteBiTuple.class) {
                Class<?> keyCls = Class.forName(arg);
                String valClsName = (String)this.argument(startIdx + 1);
                assert (valClsName != null);
                Class<?> valCls = Class.forName(valClsName);
                return new IgniteBiTuple<Object, Object>(this.toObject(keyCls, (String)this.argument(startIdx + 2)), this.toObject(valCls, (String)this.argument(startIdx + 3)));
            }
            if (cls == Map.class) {
                Class<?> keyCls = Class.forName(arg);
                String valClsName = (String)this.argument(startIdx + 1);
                assert (valClsName != null);
                Class<?> valCls = Class.forName(valClsName);
                HashMap<Object, Object> res = new HashMap<Object, Object>();
                String entries = (String)this.argument(startIdx + 2);
                if (entries != null) {
                    for (String entry2 : entries.split(";")) {
                        if (entry2.isEmpty()) continue;
                        String[] values2 = entry2.split("=");
                        assert (values2.length >= 1);
                        res.put(this.toObject(keyCls, values2[0]), values2.length > 1 ? this.toObject(valCls, values2[1]) : null);
                    }
                }
                return res;
            }
            if (cls == GridTuple3.class) {
                String v2ClsName = (String)this.argument(startIdx + 1);
                String v3ClsName = (String)this.argument(startIdx + 2);
                assert (v2ClsName != null);
                assert (v3ClsName != null);
                Class<?> v1Cls = Class.forName(arg);
                Class<?> v2Cls = Class.forName(v2ClsName);
                Class<?> v3Cls = Class.forName(v3ClsName);
                return new GridTuple3<Object, Object, Object>(this.toObject(v1Cls, (String)this.argument(startIdx + 3)), this.toObject(v2Cls, (String)this.argument(startIdx + 4)), this.toObject(v3Cls, (String)this.argument(startIdx + 5)));
            }
            return this.toObject(cls, arg);
        }

        @Nullable
        private Object toObject(Class cls, String val) {
            if (val == null || "null".equals(val) || "nil".equals(val)) {
                return null;
            }
            if (String.class == cls) {
                return val;
            }
            if (Boolean.class == cls || Boolean.TYPE == cls) {
                return Boolean.parseBoolean(val);
            }
            if (Integer.class == cls || Integer.TYPE == cls) {
                return Integer.parseInt(val);
            }
            if (Long.class == cls || Long.TYPE == cls) {
                return Long.parseLong(val);
            }
            if (UUID.class == cls) {
                return UUID.fromString(val);
            }
            if (IgniteUuid.class == cls) {
                return IgniteUuid.fromString(val);
            }
            if (Byte.class == cls || Byte.TYPE == cls) {
                return Byte.parseByte(val);
            }
            if (Short.class == cls || Short.TYPE == cls) {
                return Short.parseShort(val);
            }
            if (Float.class == cls || Float.TYPE == cls) {
                return Float.valueOf(Float.parseFloat(val));
            }
            if (Double.class == cls || Double.TYPE == cls) {
                return Double.parseDouble(val);
            }
            if (BigDecimal.class == cls) {
                return new BigDecimal(val);
            }
            if (Collection.class == cls || List.class == cls) {
                return Arrays.asList(val.split(";"));
            }
            if (Set.class == cls) {
                return new HashSet<String>(Arrays.asList(val.split(";")));
            }
            if (Object[].class == cls) {
                return val.split(";");
            }
            if (byte[].class == cls) {
                String[] els = val.split(";");
                if (els.length == 0 || els.length == 1 && els[0].isEmpty()) {
                    return ZERO_BYTES;
                }
                byte[] res = new byte[els.length];
                for (int i = 0; i < els.length; ++i) {
                    res[i] = Byte.valueOf(els[i]);
                }
                return res;
            }
            if (cls.isEnum()) {
                return Enum.valueOf(cls, val);
            }
            return val;
        }

        private static boolean isBuildInObject(Class cls) {
            return cls.isPrimitive() || cls.getName().startsWith("java.") || IgniteUuid.class == cls || IgniteBiTuple.class == cls || GridTuple3.class == cls;
        }

        private Class toClass(int idx) throws ClassNotFoundException {
            Object arg = this.argument(idx);
            return Class.forName(String.valueOf(arg));
        }

        @Override
        public Object execute() throws IgniteException {
            ArrayList<UUID> nids;
            if (this.fut != null) {
                return this.fut.get();
            }
            String nidsArg = (String)this.argument(0);
            String taskName = (String)this.argument(1);
            Object jobArgs = null;
            if (this.argsCnt > 2) {
                String argClsName = (String)this.argument(2);
                assert (argClsName != null);
                try {
                    Class<?> argCls = Class.forName(argClsName);
                    if (argCls == Void.class) {
                        jobArgs = null;
                    } else if (VisorGatewayJob.isBuildInObject(argCls)) {
                        jobArgs = this.toJobArgument(argCls, 3);
                    } else {
                        int beanArgsCnt = this.argsCnt - 3;
                        Constructor<?>[] constructorArray = argCls.getDeclaredConstructors();
                        int n = constructorArray.length;
                        for (int i = 0; i < n; ++i) {
                            int args2;
                            Object ctor = constructorArray[i];
                            Class<?>[] types2 = ((Constructor)ctor).getParameterTypes();
                            int needArgs = args2 = types2.length;
                            for (Class<?> type : types2) {
                                if (!TYPE_ARG_LENGTH.containsKey(type)) continue;
                                needArgs += ((Integer)TYPE_ARG_LENGTH.get(type)).intValue();
                            }
                            if (needArgs != beanArgsCnt) continue;
                            Object[] initArgs = new Object[args2];
                            int i2 = 0;
                            int ctrIdx = 0;
                            while (i2 < beanArgsCnt) {
                                Class<?> type;
                                type = types2[ctrIdx];
                                if (TYPE_ARG_LENGTH.containsKey(type)) {
                                    initArgs[ctrIdx] = this.toJobArgument(this.toClass(3 + i2), 4 + i2);
                                    i2 += ((Integer)TYPE_ARG_LENGTH.get(type)).intValue();
                                } else {
                                    String val = (String)this.argument(3 + i2);
                                    initArgs[ctrIdx] = this.toObject(type, val);
                                }
                                ++i2;
                                ++ctrIdx;
                            }
                            ((Constructor)ctor).setAccessible(true);
                            jobArgs = ((Constructor)ctor).newInstance(initArgs);
                            break;
                        }
                        if (jobArgs == null) {
                            Object[] args3 = new Object[beanArgsCnt];
                            for (int i = 0; i < beanArgsCnt; ++i) {
                                args3[i] = this.argument(i + 3);
                            }
                            throw new IgniteException("Failed to find constructor for task argument [taskName=" + taskName + ", argsCnt=" + args3.length + ", args=" + Arrays.toString(args3) + "]");
                        }
                    }
                }
                catch (Exception e) {
                    throw new IgniteException("Failed to construct job argument [taskName=" + taskName + "]", e);
                }
            }
            if (F.isEmpty(nidsArg) || "null".equals(nidsArg)) {
                try {
                    Class<?> taskCls = Class.forName(taskName);
                    if (VisorCoordinatorNodeTask.class.isAssignableFrom(taskCls)) {
                        ClusterNode crd = this.ignite.context().discovery().discoCache().oldestAliveServerNode();
                        nids = Collections.singletonList(crd.id());
                    }
                    if (VisorOneNodeTask.class.isAssignableFrom(taskCls)) {
                        nids = Collections.singletonList(this.ignite.localNode().id());
                    }
                    Collection<ClusterNode> nodes2 = this.ignite.cluster().nodes();
                    nids = new ArrayList(nodes2.size());
                    for (ClusterNode node : nodes2) {
                        nids.add(node.id());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IgniteException("Failed to find task class:" + taskName, e);
                }
            } else {
                String[] items = nidsArg.split(";");
                nids = new ArrayList(items.length);
                for (String item : items) {
                    try {
                        nids.add(UUID.fromString(item));
                    }
                    catch (IllegalArgumentException ignore) {
                        this.ignite.log().warning("Failed to parse node id [taskName=" + taskName + ", nid=" + item + "]");
                    }
                }
            }
            IgniteCompute comp = this.ignite.compute(this.ignite.cluster().forNodeIds(nids));
            this.fut = comp.executeAsync(taskName, new VisorTaskArgument<Object>(nids, jobArgs, false));
            this.fut.listen(new CI1<IgniteFuture<Object>>(){

                @Override
                public void apply(IgniteFuture<Object> f2) {
                    jobCtx.callcc();
                }
            });
            return this.jobCtx.holdcc();
        }
    }
}

