/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.compute;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.compute.VisorComputeCancelSessionsTaskArg;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorComputeCancelSessionsTask
extends VisorOneNodeTask<VisorComputeCancelSessionsTaskArg, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorComputeCancelSessionsJob job(VisorComputeCancelSessionsTaskArg arg) {
        return new VisorComputeCancelSessionsJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Void reduce0(List<ComputeJobResult> results) {
        return null;
    }

    private static class VisorComputeCancelSessionsJob
    extends VisorJob<VisorComputeCancelSessionsTaskArg, Void> {
        private static final long serialVersionUID = 0L;

        private VisorComputeCancelSessionsJob(VisorComputeCancelSessionsTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Void run(VisorComputeCancelSessionsTaskArg arg) {
            Set<IgniteUuid> sesIds = arg.getSessionIds();
            if (sesIds != null && !sesIds.isEmpty()) {
                IgniteCompute compute2 = this.ignite.compute(this.ignite.cluster().forLocal());
                Map futs = compute2.activeTaskFutures();
                for (IgniteUuid sesId : sesIds) {
                    ComputeTaskFuture fut = futs.get(sesId);
                    if (fut == null) continue;
                    fut.cancel();
                }
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorComputeCancelSessionsJob.class, this);
        }
    }
}

