/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorPartitionMap
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Map<Integer, GridDhtPartitionState> parts;

    public VisorPartitionMap() {
    }

    public VisorPartitionMap(GridDhtPartitionMap map2) {
        this.parts = map2.map();
    }

    public Map<Integer, GridDhtPartitionState> getPartitions() {
        return this.parts;
    }

    public int size() {
        return this.parts.size();
    }

    public GridDhtPartitionState get(Integer part) {
        return this.parts.get(part);
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        if (this.parts != null) {
            out.writeInt(this.parts.size());
            for (Map.Entry<Integer, GridDhtPartitionState> e : this.parts.entrySet()) {
                out.writeInt(e.getKey());
                U.writeEnum(out, (Enum)e.getValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 == -1) {
            this.parts = null;
        } else {
            this.parts = new HashMap<Integer, GridDhtPartitionState>(size2, 1.0f);
            for (int i = 0; i < size2; ++i) {
                this.parts.put(in.readInt(), GridDhtPartitionState.fromOrdinal(in.readByte()));
            }
        }
    }

    public String toString() {
        return S.toString(VisorPartitionMap.class, this);
    }
}

