/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.cache.VisorCacheSqlIndexMetadata;

public class VisorCacheSqlMetadata
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private List<String> types;
    private Map<String, String> keyClasses;
    private Map<String, String> valClasses;
    private Map<String, Map<String, String>> fields;
    private Map<String, List<VisorCacheSqlIndexMetadata>> indexes;

    public VisorCacheSqlMetadata() {
    }

    public VisorCacheSqlMetadata(GridCacheSqlMetadata meta) {
        this.cacheName = meta.cacheName();
        this.types = VisorCacheSqlMetadata.toList(meta.types());
        this.keyClasses = meta.keyClasses();
        this.valClasses = meta.valClasses();
        this.fields = meta.fields();
        this.indexes = new HashMap<String, List<VisorCacheSqlIndexMetadata>>();
        Map<String, Collection<GridCacheSqlIndexMetadata>> src = meta.indexes();
        if (src != null) {
            for (Map.Entry<String, Collection<GridCacheSqlIndexMetadata>> entry2 : src.entrySet()) {
                Collection<GridCacheSqlIndexMetadata> idxs = entry2.getValue();
                ArrayList<VisorCacheSqlIndexMetadata> res = new ArrayList<VisorCacheSqlIndexMetadata>(idxs.size());
                for (GridCacheSqlIndexMetadata idx : idxs) {
                    res.add(new VisorCacheSqlIndexMetadata(idx));
                }
                this.indexes.put(entry2.getKey(), res);
            }
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public Map<String, String> getKeyClasses() {
        return this.keyClasses;
    }

    public Map<String, String> getValueClasses() {
        return this.valClasses;
    }

    public Map<String, Map<String, String>> getFields() {
        return this.fields;
    }

    public Map<String, List<VisorCacheSqlIndexMetadata>> getIndexes() {
        return this.indexes;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.cacheName);
        U.writeCollection(out, this.types);
        IgfsUtils.writeStringMap(out, this.keyClasses);
        IgfsUtils.writeStringMap(out, this.valClasses);
        U.writeMap(out, this.fields);
        U.writeMap(out, this.indexes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheName = U.readString(in);
        this.types = U.readList(in);
        this.keyClasses = IgfsUtils.readStringMap(in);
        this.valClasses = IgfsUtils.readStringMap(in);
        this.fields = U.readMap(in);
        this.indexes = U.readMap(in);
    }

    public String toString() {
        return S.toString(VisorCacheSqlMetadata.class, this);
    }
}

