/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheLoadTaskArg;

@GridInternal
public class VisorCacheLoadTask
extends VisorOneNodeTask<VisorCacheLoadTaskArg, Map<String, Integer>> {
    private static final long serialVersionUID = 0L;

    protected VisorCachesLoadJob job(VisorCacheLoadTaskArg arg) {
        return new VisorCachesLoadJob(arg, this.debug);
    }

    private static class VisorCachesLoadJob
    extends VisorJob<VisorCacheLoadTaskArg, Map<String, Integer>> {
        private static final long serialVersionUID = 0L;

        private VisorCachesLoadJob(VisorCacheLoadTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Map<String, Integer> run(VisorCacheLoadTaskArg arg) {
            Set<String> cacheNames = arg.getCacheNames();
            long ttl = arg.getTtl();
            Object[] ldrArgs = arg.getLoaderArguments();
            assert (cacheNames != null && !cacheNames.isEmpty());
            HashMap<String, Integer> res = U.newHashMap(cacheNames.size());
            CreatedExpiryPolicy plc = null;
            for (String cacheName : cacheNames) {
                IgniteCache cache = this.ignite.cache(cacheName);
                if (cache == null) {
                    throw new IllegalStateException("Failed to find cache for name: " + cacheName);
                }
                if (ttl > 0L) {
                    if (plc == null) {
                        plc = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl));
                    }
                    cache = cache.withExpiryPolicy(plc);
                }
                cache.loadCache(null, ldrArgs);
                res.put(cacheName, cache.size(CachePeekMode.PRIMARY));
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorCachesLoadJob.class, this);
        }
    }
}

