/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.worker;

import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeExecutionRejectedException;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;

public class GridWorkerPool {
    private final Executor exec;
    private final IgniteLogger log;
    private final Collection<GridWorker> workers = new GridConcurrentHashSet<GridWorker>();

    public GridWorkerPool(Executor exec2, IgniteLogger log2) {
        assert (exec2 != null);
        assert (log2 != null);
        this.exec = exec2;
        this.log = log2;
    }

    public void execute(final GridWorker w) throws IgniteCheckedException {
        this.workers.add(w);
        try {
            this.exec.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        w.run();
                    }
                    finally {
                        GridWorkerPool.this.workers.remove(w);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.workers.remove(w);
            throw new ComputeExecutionRejectedException("Failed to execute worker due to execution rejection.", e);
        }
        catch (RuntimeException e) {
            this.workers.remove(w);
            throw new IgniteCheckedException("Failed to execute worker due to runtime exception.", e);
        }
        catch (Error e) {
            this.workers.remove(w);
            throw e;
        }
    }

    public void join(boolean cancel) {
        if (cancel) {
            U.cancel(this.workers);
        }
        boolean interrupted = Thread.interrupted();
        try {
            U.join(this.workers, this.log);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

