/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.typedef;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

public final class X {
    public static final Object[] EMPTY_OBJECT_ARRAY;
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long SECONDS_IN_MINUTE = 60L;
    private static final long MINUTES_IN_HOUR = 60L;
    private static final long HOURS_IN_DAY = 24L;
    private static final long[] SPAN_DIVS;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final String[] CAUSE_MTD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;

    private X() {
    }

    public static void println() {
        System.out.println();
    }

    public static void printerrln() {
        System.err.println();
    }

    public static void println(@Nullable String s1, Object ... rest2) {
        System.out.println(s1);
        if (rest2 != null && rest2.length > 0) {
            for (Object obj : rest2) {
                System.out.println(obj);
            }
        }
    }

    public static void printerrln(@Nullable String s1, Object ... rest2) {
        X.error(s1, rest2);
    }

    public static void error(@Nullable String s1, Object ... rest2) {
        System.err.println(s1);
        if (rest2 != null && rest2.length > 0) {
            for (Object obj : rest2) {
                System.err.println(obj);
            }
        }
    }

    public static void print(@Nullable String s1, Object ... rest2) {
        System.out.print(s1);
        if (rest2 != null && rest2.length > 0) {
            for (Object obj : rest2) {
                System.out.print(obj);
            }
        }
    }

    public static void printerr(@Nullable String s1, Object ... rest2) {
        System.err.print(s1);
        if (rest2 != null && rest2.length > 0) {
            for (Object obj : rest2) {
                System.err.print(obj);
            }
        }
    }

    @Nullable
    public static String getSystemOrEnv(String name) {
        assert (name != null);
        String v = System.getProperty(name);
        if (v == null) {
            v = System.getenv(name);
        }
        return v;
    }

    public static String timeSpan2HMSM(long span2) {
        long[] t = new long[4];
        int i = 0;
        for (long sp2 = span2; i < SPAN_DIVS.length && sp2 > 0L; sp2 /= SPAN_DIVS[i++]) {
            t[i] = sp2 % SPAN_DIVS[i];
        }
        return (t[3] < 10L ? "0" + t[3] : Long.toString(t[3])) + ':' + (t[2] < 10L ? "0" + t[2] : Long.toString(t[2])) + ':' + (t[1] < 10L ? "0" + t[1] : Long.toString(t[1])) + '.' + (t[0] < 10L ? "00" + t[0] : (t[0] < 100L ? "0" + t[0] : Long.toString(t[0])));
    }

    public static String timeSpan2HMS(long span2) {
        long[] t = new long[4];
        int i = 0;
        for (long sp2 = span2; i < SPAN_DIVS.length && sp2 > 0L; sp2 /= SPAN_DIVS[i++]) {
            t[i] = sp2 % SPAN_DIVS[i];
        }
        return (t[3] < 10L ? "0" + t[3] : Long.toString(t[3])) + ':' + (t[2] < 10L ? "0" + t[2] : Long.toString(t[2])) + ':' + (t[1] < 10L ? "0" + t[1] : Long.toString(t[1]));
    }

    public static String timeSpan2DHMSM(long span2) {
        String days = "";
        String hmsm = X.timeSpan2HMSM(span2 % 86400000L);
        long daysCnt = span2 / 86400000L;
        if (daysCnt == 1L) {
            days = "1 day, ";
        } else if (daysCnt > 1L) {
            days = daysCnt + " days, ";
        }
        return days + hmsm;
    }

    @Nullable
    public static <T> T cloneObject(@Nullable T obj, boolean deep, boolean honorCloneable) {
        if (obj == null) {
            return null;
        }
        try {
            return (T)(!deep ? X.shallowClone(obj) : X.deepClone(new GridLeanMap<Integer, Integer>(), new ArrayList<Object>(), obj, honorCloneable));
        }
        catch (Exception e) {
            throw new IgniteException("Unable to clone instance of class: " + obj.getClass(), e);
        }
    }

    @Nullable
    private static <T> T shallowClone(@Nullable T obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Cloneable)) {
            return obj;
        }
        if (obj.getClass().isArray()) {
            return (T)(obj instanceof byte[] ? ((byte[])obj).clone() : (obj instanceof short[] ? ((short[])obj).clone() : (obj instanceof char[] ? ((char[])obj).clone() : (obj instanceof int[] ? ((int[])obj).clone() : (obj instanceof long[] ? ((long[])obj).clone() : (obj instanceof float[] ? ((float[])obj).clone() : (obj instanceof double[] ? ((double[])obj).clone() : (obj instanceof boolean[] ? ((boolean[])obj).clone() : ((Object[])obj).clone()))))))));
        }
        try {
            Method mtd = obj.getClass().getDeclaredMethod("clone", new Class[0]);
            boolean set = false;
            if (!mtd.isAccessible()) {
                set = true;
                mtd.setAccessible(true);
            }
            Object clone2 = mtd.invoke(obj, new Object[0]);
            if (set) {
                mtd.setAccessible(false);
            }
            return (T)clone2;
        }
        catch (Exception e) {
            throw new IgniteException("Unable to clone instance of class: " + obj.getClass(), e);
        }
    }

    @Nullable
    private static Object deepClone(Map<Integer, Integer> identityIdxs, List<Object> clones, @Nullable Object obj, boolean honorCloneable) throws Exception {
        if (obj == null) {
            return null;
        }
        if (honorCloneable && obj instanceof Cloneable) {
            return X.shallowClone(obj);
        }
        Integer idx = identityIdxs.get(System.identityHashCode(obj));
        Object clone2 = null;
        if (idx != null) {
            clone2 = clones.get(idx);
        }
        if (clone2 != null) {
            return clone2;
        }
        if (obj instanceof Class) {
            return obj;
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            Class<?> arrType = cls.getComponentType();
            int len = Array.getLength(obj);
            clone2 = Array.newInstance(arrType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(clone2, i, X.deepClone(identityIdxs, clones, Array.get(obj, i), honorCloneable));
            }
            clones.add(clone2);
            identityIdxs.put(System.identityHashCode(obj), clones.size() - 1);
            return clone2;
        }
        clone2 = U.forceNewInstance(cls);
        if (clone2 == null) {
            throw new IgniteException("Failed to clone object (empty constructor could not be assigned): " + obj);
        }
        clones.add(clone2);
        identityIdxs.put(System.identityHashCode(obj), clones.size() - 1);
        for (Class<?> c = cls; c != Object.class; c = c.getSuperclass()) {
            for (Field f2 : c.getDeclaredFields()) {
                X.cloneField(identityIdxs, clones, obj, clone2, f2, honorCloneable);
            }
        }
        return clone2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cloneField(Map<Integer, Integer> identityIdxs, List<Object> clones, Object obj, Object clone2, Field f2, boolean honorCloneable) throws Exception {
        int modifiers = f2.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return;
        }
        boolean set = false;
        if (!f2.isAccessible()) {
            f2.setAccessible(true);
            set = true;
        }
        try {
            if (f2.getType().isPrimitive()) {
                f2.set(clone2, f2.get(obj));
            } else {
                f2.set(clone2, X.deepClone(identityIdxs, clones, f2.get(obj), honorCloneable));
            }
        }
        finally {
            if (set) {
                f2.setAccessible(false);
            }
        }
    }

    @SafeVarargs
    public static boolean hasCause(@Nullable Throwable t, Class<?> ... cls) {
        if (t == null || F.isEmpty(cls)) {
            return false;
        }
        assert (cls != null);
        for (Throwable th = t; th != null; th = th.getCause()) {
            for (Class<?> clazz2 : cls) {
                if (!clazz2.isAssignableFrom(th.getClass())) continue;
                return true;
            }
            for (Serializable serializable : th.getSuppressed()) {
                if (!X.hasCause((Throwable)serializable, cls)) continue;
                return true;
            }
            if (th.getCause() == th) break;
        }
        return false;
    }

    public static boolean hasSuppressed(@Nullable Throwable t, @Nullable Class<? extends Throwable> cls) {
        if (t == null || cls == null) {
            return false;
        }
        for (Throwable th : t.getSuppressed()) {
            if (cls.isAssignableFrom(th.getClass())) {
                return true;
            }
            if (!X.hasSuppressed(th, cls)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends Throwable> T cause(@Nullable Throwable t, @Nullable Class<T> cls) {
        if (t == null || cls == null) {
            return null;
        }
        for (Throwable th = t; th != null; th = th.getCause()) {
            if (cls.isAssignableFrom(th.getClass())) {
                return (T)th;
            }
            for (Throwable n : th.getSuppressed()) {
                T found = X.cause(n, cls);
                if (found == null) continue;
                return found;
            }
            if (th.getCause() == th) break;
        }
        return null;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable2) {
        if (throwable2 instanceof SQLException) {
            return ((SQLException)throwable2).getNextException();
        }
        if (throwable2 instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable2).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable2, String mtdName) {
        Method mtd = null;
        try {
            mtd = throwable2.getClass().getMethod(mtdName, null);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (mtd != null && Throwable.class.isAssignableFrom(mtd.getReturnType())) {
            try {
                return (Throwable)mtd.invoke((Object)throwable2, EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable2, String fieldName) {
        Field field2 = null;
        try {
            field2 = throwable2.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (field2 != null && Throwable.class.isAssignableFrom(field2.getType())) {
            try {
                return (Throwable)field2.get(throwable2);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable2) {
        if (throwable2 == null) {
            return false;
        }
        if (throwable2 instanceof SQLException || throwable2 instanceof InvocationTargetException) {
            return true;
        }
        if (X.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable2.getClass();
        for (String CAUSE_MTD_NAME : CAUSE_MTD_NAMES) {
            try {
                Method mtd = cls.getMethod(CAUSE_MTD_NAME, null);
                if (mtd == null || !Throwable.class.isAssignableFrom(mtd.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        try {
            Field field2 = cls.getField("detail");
            if (field2 != null) {
                return true;
            }
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    public static Throwable getCause(Throwable throwable2) {
        return X.getCause(throwable2, CAUSE_MTD_NAMES);
    }

    public static Throwable getCause(Throwable throwable2, String[] mtdNames) {
        if (throwable2 == null) {
            return null;
        }
        Throwable cause = X.getCauseUsingWellKnownTypes(throwable2);
        if (cause == null) {
            if (mtdNames == null) {
                mtdNames = CAUSE_MTD_NAMES;
            }
            for (String mtdName : mtdNames) {
                if (mtdName != null && (cause = X.getCauseUsingMethodName(throwable2, mtdName)) != null) break;
            }
            if (cause == null) {
                cause = X.getCauseUsingFieldName(throwable2, "detail");
            }
        }
        return cause;
    }

    public static List<Throwable> getThrowableList(Throwable throwable2) {
        ArrayList<Throwable> list2 = new ArrayList<Throwable>();
        while (throwable2 != null && !list2.contains(throwable2)) {
            list2.add(throwable2);
            throwable2 = X.getCause(throwable2);
        }
        return list2;
    }

    public static Throwable[] getThrowables(Throwable throwable2) {
        List<Throwable> list2 = X.getThrowableList(throwable2);
        return list2.toArray(new Throwable[list2.size()]);
    }

    public static List<Throwable> getSuppressedList(@Nullable Throwable t) {
        ArrayList<Throwable> result2 = new ArrayList<Throwable>();
        if (t == null) {
            return result2;
        }
        do {
            for (Throwable suppressed : t.getSuppressed()) {
                result2.add(suppressed);
                result2.addAll(X.getSuppressedList(suppressed));
            }
        } while ((t = t.getCause()) != null);
        return result2;
    }

    public static String getFullStackTrace(Throwable throwable2) {
        Throwable[] ts;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        for (Throwable t : ts = X.getThrowables(throwable2)) {
            t.printStackTrace(pw);
            if (X.isNestedThrowable(t)) break;
        }
        return sw.getBuffer().toString();
    }

    public static void waitAll(@Nullable Iterable<IgniteFuture<?>> futs) {
        if (F.isEmpty(futs)) {
            return;
        }
        for (IgniteFuture<?> fut : futs) {
            fut.get();
        }
    }

    public static String formatMins(long mins) {
        long hh;
        assert (mins >= 0L);
        if (mins == 0L) {
            return "< 1 min";
        }
        SB sb = new SB();
        long dd2 = mins / 1440L;
        if (dd2 > 0L) {
            sb.a(dd2).a(dd2 == 1L ? " day " : " days ");
        }
        if ((hh = (mins %= 1440L) / 60L) > 0L) {
            sb.a(hh).a(hh == 1L ? " hour " : " hours ");
        }
        if ((mins %= 60L) > 0L) {
            sb.a(mins).a(mins == 1L ? " min " : " mins ");
        }
        return sb.toString().trim();
    }

    public static void checkMinMemory(long min2) {
        long maxMem = Runtime.getRuntime().maxMemory();
        if ((double)maxMem < 0.85 * (double)min2) {
            X.printerrln("Heap limit is too low (" + maxMem / 0x100000L + "MB), please increase heap size at least up to " + min2 / 0x100000L + "MB.", new Object[0]);
            System.exit(-1);
        }
    }

    public static int copy(InputStream in, OutputStream out, int bufSize) throws IOException {
        int n;
        byte[] buf = new byte[bufSize];
        int cnt = 0;
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
            cnt += n;
        }
        return cnt;
    }

    public static String resolveIgniteHome() throws IgniteCheckedException {
        String var = IgniteSystemProperties.getString("IGNITE_HOME");
        if (var != null) {
            return var;
        }
        throw new IgniteCheckedException("Failed to resolve Ignite home folder (please set 'IGNITE_HOME' environment or system variable)");
    }

    public static double parseDouble(@Nullable String s2, double dflt) {
        try {
            return s2 != null ? Double.parseDouble(s2) : dflt;
        }
        catch (NumberFormatException ignored) {
            return dflt;
        }
    }

    static {
        Method causeMtd;
        EMPTY_OBJECT_ARRAY = new Object[0];
        SPAN_DIVS = new long[]{1000L, 60L, 60L, 24L};
        CAUSE_MTD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            causeMtd = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception ignored) {
            causeMtd = null;
        }
        THROWABLE_CAUSE_METHOD = causeMtd;
    }
}

