/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.util.tostring.GridToStringFieldDescriptor;

class GridToStringClassDescriptor {
    private final String sqn;
    private final String fqn;
    private List<GridToStringFieldDescriptor> fields = new ArrayList<GridToStringFieldDescriptor>();

    GridToStringClassDescriptor(Class<?> cls) {
        assert (cls != null);
        this.fqn = cls.getName();
        this.sqn = cls.getSimpleName();
    }

    void addField(GridToStringFieldDescriptor field2) {
        assert (field2 != null);
        this.fields.add(field2);
    }

    void sortFields() {
        Collections.sort(this.fields, new Comparator<GridToStringFieldDescriptor>(){

            @Override
            public int compare(GridToStringFieldDescriptor arg0, GridToStringFieldDescriptor arg1) {
                return arg0.getOrder() < arg1.getOrder() ? -1 : (arg0.getOrder() > arg1.getOrder() ? 1 : 0);
            }
        });
    }

    String getSimpleClassName() {
        return this.sqn;
    }

    String getFullyQualifiedClassName() {
        return this.fqn;
    }

    List<GridToStringFieldDescriptor> getFields() {
        return this.fields;
    }
}

