/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.offheap.unsafe;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.util.offheap.GridOffHeapOutOfMemoryException;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

class GridUnsafeLru {
    private final short cnt;
    @GridToStringExclude
    private final LruStripe[] lrus;
    @GridToStringExclude
    private final GridUnsafeMemory mem;
    private final AtomicInteger addIdx;
    private final AtomicInteger rmvIdx;
    private final int maxIdxCnt;
    private AtomicBoolean released = new AtomicBoolean(false);

    GridUnsafeLru(short cnt, GridUnsafeMemory mem) {
        assert (cnt > 0);
        assert (mem != null);
        this.lrus = new LruStripe[cnt];
        this.cnt = cnt;
        this.mem = mem;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            this.lrus[i] = new LruStripe(i, mem);
        }
        this.addIdx = new AtomicInteger();
        this.rmvIdx = new AtomicInteger(cnt / 2);
        this.maxIdxCnt = cnt - 1;
    }

    short concurrency() {
        return this.cnt;
    }

    long size() {
        long sum2 = 0L;
        for (int i = 0; i < this.lrus.length; ++i) {
            sum2 += this.lrus[i].size();
        }
        return sum2;
    }

    long memorySize() {
        long sum2 = 0L;
        for (int i = 0; i < this.lrus.length; ++i) {
            sum2 += this.lrus[i].memorySize();
        }
        return sum2;
    }

    short order(long qAddr) {
        return LruStripe.order(qAddr, this.mem);
    }

    int partition(short order, long qAddr) {
        return this.lrus[order].partition(qAddr);
    }

    int hash(short order, long qAddr) {
        return this.lrus[order].hash(qAddr);
    }

    long entry(short order, long qAddr) {
        return this.lrus[order].entry(qAddr);
    }

    long offer(int part, long addr, int hash) throws GridOffHeapOutOfMemoryException {
        return this.lrus[this.incrementAndGet(this.addIdx, this.maxIdxCnt)].offer(part, addr, hash);
    }

    long prePoll() {
        int idx = this.incrementAndGet(this.rmvIdx, this.maxIdxCnt);
        for (int i = 0; i < this.lrus.length; ++i) {
            long qAddr = this.lrus[(idx + i) % this.cnt].prePoll();
            if (qAddr == 0L) continue;
            return qAddr;
        }
        return 0L;
    }

    void poll(long qAddr) {
        this.lrus[LruStripe.order(qAddr, this.mem)].poll(qAddr);
    }

    void touch(long qAddr, long addr) {
        this.lrus[LruStripe.order(qAddr, this.mem)].touch(qAddr, addr);
    }

    void remove(long qAddr) {
        this.lrus[LruStripe.order(qAddr, this.mem)].remove(qAddr);
    }

    void destruct() {
        if (this.released.compareAndSet(false, true)) {
            for (int i = 0; i < this.cnt; ++i) {
                this.lrus[i].destruct();
            }
        }
    }

    private int incrementAndGet(AtomicInteger value2, int max2) {
        int next2;
        int cur;
        while (!value2.compareAndSet(cur, next2 = (cur = value2.get()) == max2 ? 0 : cur + 1)) {
        }
        return next2;
    }

    public String toString() {
        return S.toString(GridUnsafeLru.class, this);
    }

    private static class LruStripe {
        private static final int NODE = 35;
        private final GridUnsafeMemory mem;
        private final short order;
        private long head;
        private long tail;
        private volatile long size;
        private final Lock lock = new ReentrantLock();

        private LruStripe(short order, GridUnsafeMemory mem) {
            assert (order >= 0);
            assert (mem != null);
            this.order = order;
            this.mem = mem;
        }

        static short order(long qAddr, GridUnsafeMemory mem) {
            return mem.readShort(qAddr);
        }

        int order() {
            return this.order;
        }

        long size() {
            return this.size;
        }

        long memorySize() {
            return this.size * 35L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destruct() {
            this.lock.lock();
            try {
                long n = this.head;
                long prev = 0L;
                while (n != 0L) {
                    this.mem.releaseSystem(prev, 35L);
                    prev = n;
                    n = this.next(n);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long offer(int part, long addr, int hash) throws GridOffHeapOutOfMemoryException {
            this.lock.lock();
            try {
                long qAddr = this.mem.allocateSystem(35L, false);
                if (this.head == 0L) {
                    this.head = qAddr;
                }
                long prev = this.tail;
                this.tail = qAddr;
                if (prev != 0L) {
                    this.next(prev, qAddr);
                }
                this.order(qAddr);
                this.partition(qAddr, part);
                this.polling(qAddr, false);
                this.hash(qAddr, hash);
                this.entry(qAddr, addr);
                this.previous(qAddr, prev);
                this.next(qAddr, 0L);
                ++this.size;
                long l = qAddr;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long prePoll() {
            this.lock.lock();
            try {
                long n = this.head;
                while (n != 0L) {
                    if (!this.polling(n)) {
                        this.polling(n, true);
                        break;
                    }
                    n = this.next(n);
                }
                long l = n;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void touch(long qAddr, long addr) {
            this.lock.lock();
            try {
                this.entry(qAddr, addr);
                if (qAddr != this.tail) {
                    long prev = this.previous(qAddr);
                    long next2 = this.next(qAddr);
                    if (prev != 0L) {
                        this.next(prev, next2);
                    } else {
                        assert (qAddr == this.head);
                        this.head = next2;
                    }
                    if (next2 != 0L) {
                        this.previous(next2, prev);
                    }
                    this.next(this.tail, qAddr);
                    this.next(qAddr, 0L);
                    this.previous(qAddr, this.tail);
                    this.tail = qAddr;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        void poll(long qAddr) {
            this.lock.lock();
            try {
                assert (this.polling(qAddr));
                this.unlink(qAddr);
            }
            finally {
                this.lock.unlock();
            }
        }

        void remove(long qAddr) {
            this.lock.lock();
            try {
                if (!this.polling(qAddr)) {
                    this.unlink(qAddr);
                } else {
                    this.entry(qAddr, 0L);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void unlink(long qAddr) {
            assert (this.head != 0L && this.tail != 0L);
            long prev = 0L;
            long next2 = this.next(qAddr);
            if (this.head == qAddr) {
                this.head = next2;
            } else {
                prev = this.previous(qAddr);
                assert (prev != 0L) : "Invalid previous link for stripe: " + this.order;
                this.next(prev, next2);
            }
            if (next2 != 0L) {
                this.previous(next2, prev);
            } else {
                assert (qAddr == this.tail);
                this.tail = prev;
            }
            this.mem.releaseSystem(qAddr, 35L);
            --this.size;
            assert (this.head != 0L || this.tail == 0L && this.size == 0L);
        }

        private void order(long qAddr) {
            this.mem.writeShort(qAddr, this.order);
        }

        private int partition(long qAddr) {
            return this.mem.readInt(qAddr + 2L);
        }

        private void partition(long qAddr, int part) {
            this.mem.writeInt(qAddr + 2L, part);
        }

        private int hash(long qAddr) {
            return this.mem.readInt(qAddr + 6L);
        }

        private void hash(long qAddr, int hash) {
            this.mem.writeInt(qAddr + 6L, hash);
        }

        private boolean polling(long qAddr) {
            return this.mem.readByte(qAddr + 10L) == 1;
        }

        private void polling(long qAddr, boolean polling) {
            this.mem.writeByte(qAddr + 10L, (byte)(polling ? 1 : 0));
        }

        private long previous(long qAddr) {
            return this.mem.readLong(qAddr + 11L);
        }

        private void previous(long qAddr, long prev) {
            this.mem.writeLong(qAddr + 11L, prev);
        }

        private long next(long qAddr) {
            return this.mem.readLong(qAddr + 19L);
        }

        private void next(long qAddr, long next2) {
            this.mem.writeLong(qAddr + 19L, next2);
        }

        private long entry(long qAddr) {
            return this.mem.readLong(qAddr + 27L);
        }

        private void entry(long qAddr, long addr) {
            this.mem.writeLong(qAddr + 27L, addr);
        }

        public String toString() {
            return S.toString(LruStripe.class, this);
        }
    }
}

